/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import com.google.common.collect.Iterators;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataDSpaceCsvExportService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.springframework.beans.factory.annotation.Autowired;

public class MetadataDSpaceCsvExportServiceImpl
implements MetadataDSpaceCsvExportService {
    @Autowired
    private ItemService itemService;

    @Override
    public DSpaceCSV handleExport(Context context, boolean exportAllItems, boolean exportAllMetadata, String handle, DSpaceRunnableHandler handler) throws Exception {
        Iterator<Item> toExport = null;
        if (exportAllItems) {
            handler.logInfo("Exporting whole repository WARNING: May take some time!");
            toExport = this.itemService.findAll(context);
        } else {
            DSpaceObject dso = HandleServiceFactory.getInstance().getHandleService().resolveToObject(context, handle);
            if (dso == null) {
                throw new IllegalArgumentException("Item '" + handle + "' does not resolve to an item in your repository!");
            }
            if (dso.getType() == 2) {
                handler.logInfo("Exporting item '" + dso.getName() + "' (" + handle + ")");
                ArrayList<Item> item = new ArrayList<Item>();
                item.add((Item)dso);
                toExport = item.iterator();
            } else if (dso.getType() == 3) {
                handler.logInfo("Exporting collection '" + dso.getName() + "' (" + handle + ")");
                Collection collection = (Collection)dso;
                toExport = this.itemService.findByCollection(context, collection);
            } else if (dso.getType() == 4) {
                handler.logInfo("Exporting community '" + dso.getName() + "' (" + handle + ")");
                toExport = this.buildFromCommunity(context, (Community)dso);
            } else {
                throw new IllegalArgumentException("Error identifying '" + handle + "'");
            }
        }
        DSpaceCSV csv = this.export(context, toExport, exportAllMetadata);
        return csv;
    }

    @Override
    public DSpaceCSV export(Context context, Iterator<Item> toExport, boolean exportAll) throws Exception {
        Context.Mode originalMode = context.getCurrentMode();
        context.setMode(Context.Mode.READ_ONLY);
        DSpaceCSV csv = new DSpaceCSV(exportAll);
        while (toExport.hasNext()) {
            Item item = toExport.next();
            csv.addItem(item);
            context.uncacheEntity(item);
        }
        context.setMode(originalMode);
        return csv;
    }

    @Override
    public DSpaceCSV export(Context context, Community community, boolean exportAll) throws Exception {
        return this.export(context, this.buildFromCommunity(context, community), exportAll);
    }

    private Iterator<Item> buildFromCommunity(Context context, Community community) throws SQLException {
        List<Collection> collections = community.getCollections();
        Iterator<Item> result = Collections.emptyIterator();
        for (Collection collection : collections) {
            Iterator<Item> items = this.itemService.findByCollection(context, collection);
            result = this.addItemsToResult(result, items);
        }
        List<Community> communities = community.getSubcommunities();
        for (Community subCommunity : communities) {
            Iterator<Item> items = this.buildFromCommunity(context, subCommunity);
            result = this.addItemsToResult(result, items);
        }
        return result;
    }

    private Iterator<Item> addItemsToResult(Iterator<Item> result, Iterator<Item> items) {
        result = result == null ? items : Iterators.concat(result, items);
        return result;
    }
}

