/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.FileMultipleOccurencesException;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.service.components.Destroyable;
import org.dspace.importer.external.service.components.FileSource;
import org.dspace.importer.external.service.components.MetadataSource;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportService
implements Destroyable {
    private HashMap<String, MetadataSource> importSources = new HashMap();
    Logger log = LogManager.getLogger(ImportService.class);
    protected static final String ANY = "*";

    @Autowired(required=false)
    public void setImportSources(List<MetadataSource> importSources) throws MetadataSourceException {
        this.log.info("Loading " + importSources.size() + " import sources.");
        for (MetadataSource metadataSource : importSources) {
            this.importSources.put(metadataSource.getImportSource(), metadataSource);
        }
    }

    protected Map<String, MetadataSource> getImportSources() {
        return Collections.unmodifiableMap(this.importSources);
    }

    protected Collection<MetadataSource> matchingImports(String uri) {
        if (ANY.equals(uri)) {
            return this.importSources.values();
        }
        if (this.importSources.containsKey(uri)) {
            return Collections.singletonList(this.importSources.get(uri));
        }
        return Collections.emptyList();
    }

    public Collection<ImportRecord> findMatchingRecords(String uri, Item item) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                recordList.addAll(((QuerySource)metadataSource).findMatchingRecords(item));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> findMatchingRecords(String uri, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                recordList.addAll(((QuerySource)metadataSource).findMatchingRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String uri, String query) throws MetadataSourceException {
        try {
            int total = 0;
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                total += ((QuerySource)metadataSource).getRecordsCount(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public int getNbRecords(String uri, Query query) throws MetadataSourceException {
        try {
            int total = 0;
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                total += ((QuerySource)metadataSource).getRecordsCount(query);
            }
            return total;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String uri, String query, int start, int count) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                recordList.addAll(((QuerySource)metadataSource).getRecords(query, start, count));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<ImportRecord> getRecords(String uri, Query query) throws MetadataSourceException {
        try {
            LinkedList<ImportRecord> recordList = new LinkedList<ImportRecord>();
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                if (!(metadataSource instanceof QuerySource)) continue;
                recordList.addAll(((QuerySource)metadataSource).getRecords(query));
            }
            return recordList;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String uri, String id) throws MetadataSourceException {
        try {
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                QuerySource querySource;
                if (!(metadataSource instanceof QuerySource) || (querySource = (QuerySource)metadataSource).getRecord(id) == null) continue;
                return querySource.getRecord(id);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public ImportRecord getRecord(String uri, Query query) throws MetadataSourceException {
        try {
            for (MetadataSource metadataSource : this.matchingImports(uri)) {
                QuerySource querySource;
                if (!(metadataSource instanceof QuerySource) || (querySource = (QuerySource)metadataSource).getRecord(query) == null) continue;
                return querySource.getRecord(query);
            }
            return null;
        }
        catch (Exception e) {
            throw new MetadataSourceException(e);
        }
    }

    public Collection<String> getImportUrls() {
        return this.importSources.keySet();
    }

    public ImportRecord getRecord(File file, String originalName) throws FileMultipleOccurencesException, FileSourceException {
        ImportRecord importRecords = null;
        for (MetadataSource metadataSource : this.importSources.values()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                FileSource fileSource;
                if (!(metadataSource instanceof FileSource) || !(fileSource = (FileSource)metadataSource).isValidSourceForFile(originalName)) continue;
                importRecords = fileSource.getRecord(fileInputStream);
                break;
            }
            catch (FileSourceException e) {
                this.log.debug(metadataSource.getImportSource() + " isn't a valid parser for file");
            }
            catch (FileMultipleOccurencesException e) {
                this.log.debug("File contains multiple metadata, return with error");
                throw e;
            }
            catch (IOException e1) {
                throw new FileSourceException("File cannot be read, may be null");
            }
        }
        return importRecords;
    }

    @Override
    public void destroy() throws Exception {
        for (MetadataSource metadataSource : this.importSources.values()) {
            if (!(metadataSource instanceof Destroyable)) continue;
            ((Destroyable)((Object)metadataSource)).destroy();
        }
    }
}

