/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.launcher;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.TreeMap;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.services.RequestService;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ScriptLauncher {
    private static transient DSpaceKernelImpl kernelImpl;

    private ScriptLauncher() {
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        try {
            kernelImpl = DSpaceKernelInit.getKernel(null);
            if (!kernelImpl.isRunning()) {
                kernelImpl.start();
            }
        }
        catch (Exception e) {
            try {
                kernelImpl.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String message = "Failure during kernel init: " + e.getMessage();
            System.err.println(message);
            e.printStackTrace();
            throw new IllegalStateException(message, e);
        }
        Document commandConfigs = ScriptLauncher.getConfig();
        if (args.length < 1) {
            System.err.println("You must provide at least one command argument");
            ScriptLauncher.display(commandConfigs);
            System.exit(1);
        }
        int status = ScriptLauncher.runOneCommand(commandConfigs, args);
        if (kernelImpl != null) {
            kernelImpl.destroy();
            kernelImpl = null;
        }
        System.exit(status);
    }

    protected static int runOneCommand(Document commandConfigs, String[] args) {
        return ScriptLauncher.runOneCommand(commandConfigs, args, kernelImpl);
    }

    public static int runOneCommand(Document commandConfigs, String[] args, DSpaceKernelImpl kernelImpl) {
        String request = args[0];
        Element root = commandConfigs.getRootElement();
        List commands = root.getChildren("command");
        Element command = null;
        for (Element candidate : commands) {
            if (!request.equalsIgnoreCase(candidate.getChild("name").getValue())) continue;
            command = candidate;
            break;
        }
        if (null == command) {
            System.err.println("Command not found: " + args[0]);
            ScriptLauncher.display(commandConfigs);
            return 1;
        }
        List steps = command.getChildren("step");
        for (Element step : steps) {
            RequestService requestService;
            int i;
            String[] argsnew;
            String className;
            Class<?> target = null;
            if ("dsrun".equals(request)) {
                if (args.length < 2) {
                    System.err.println("Error in launcher.xml: Missing class name");
                    return 1;
                }
                className = args[1];
            } else {
                className = step.getChild("class").getValue();
            }
            try {
                target = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error in launcher.xml: Invalid class name: " + className);
                return 1;
            }
            String[] useargs = (String[])args.clone();
            Class[] argTypes = new Class[]{useargs.getClass()};
            boolean passargs = true;
            if (step.getAttribute("passuserargs") != null && "false".equalsIgnoreCase(step.getAttribute("passuserargs").getValue())) {
                passargs = false;
            }
            if (args.length == 1 || "dsrun".equals(request) && args.length == 2 || !passargs) {
                useargs = new String[]{};
            } else {
                int x = 1;
                if ("dsrun".equals(request)) {
                    x = 2;
                }
                argsnew = new String[useargs.length - x];
                for (i = x; i < useargs.length; ++i) {
                    argsnew[i - x] = useargs[i];
                }
                useargs = argsnew;
            }
            List bits = step.getChildren("argument");
            if (step.getChild("argument") != null) {
                argsnew = new String[useargs.length + bits.size()];
                i = 0;
                for (Element arg : bits) {
                    argsnew[i++] = arg.getValue();
                }
                while (i < bits.size() + useargs.length) {
                    argsnew[i] = useargs[i - bits.size()];
                    ++i;
                }
                useargs = argsnew;
            }
            if ((requestService = (RequestService)kernelImpl.getServiceManager().getServiceByName(RequestService.class.getName(), RequestService.class)) == null) {
                throw new IllegalStateException("Could not get the DSpace RequestService to start the request transaction");
            }
            requestService.startRequest();
            try {
                Object[] arguments = new Object[]{useargs};
                Method main = target.getMethod("main", argTypes);
                main.invoke(null, arguments);
                requestService.endRequest(null);
            }
            catch (Exception e) {
                requestService.endRequest(e);
                Throwable cause = e.getCause();
                System.err.println("Exception: " + cause.getMessage());
                cause.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    protected static Document getConfig() {
        return ScriptLauncher.getConfig(kernelImpl);
    }

    public static Document getConfig(DSpaceKernelImpl kernelImpl) {
        String config = kernelImpl.getConfigurationService().getProperty("dspace.dir") + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "launcher.xml";
        SAXBuilder saxBuilder = new SAXBuilder();
        Document doc = null;
        try {
            doc = saxBuilder.build(config);
        }
        catch (Exception e) {
            System.err.println("Unable to load the launcher configuration file: [dspace]/config/launcher.xml");
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        return doc;
    }

    private static void display(Document commandConfigs) {
        List commands = commandConfigs.getRootElement().getChildren("command");
        TreeMap<String, Element> sortedCommands = new TreeMap<String, Element>();
        for (Element command : commands) {
            sortedCommands.put(command.getChild("name").getValue(), command);
        }
        System.out.println("Usage: dspace [command-name] {parameters}");
        for (Element command : sortedCommands.values()) {
            System.out.println(" - " + command.getChild("name").getValue() + ": " + command.getChild("description").getValue());
        }
    }
}

