/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityServiceImpl
implements EntityService {
    @Autowired(required=true)
    protected EntityTypeService entityTypeService;
    @Autowired(required=true)
    protected RelationshipService relationshipService;
    @Autowired(required=true)
    protected RelationshipTypeService relationshipTypeService;
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public Entity findByItemId(Context context, UUID itemId) throws SQLException {
        Item item = (Item)this.itemService.find(context, itemId);
        List<Relationship> relationshipList = this.relationshipService.findByItem(context, item);
        return new Entity(item, relationshipList);
    }

    @Override
    public EntityType getType(Context context, Entity entity) throws SQLException {
        Item item = entity.getItem();
        List<MetadataValue> list = this.itemService.getMetadata(item, "relationship", "type", null, "*");
        if (!list.isEmpty()) {
            return this.entityTypeService.findByEntityType(context, list.get(0).getValue());
        }
        return null;
    }

    @Override
    public List<Relationship> getLeftRelations(Context context, Entity entity) {
        List<Relationship> fullList = entity.getRelationships();
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : fullList) {
            if (relationship.getLeftItem().getID() != entity.getItem().getID()) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> getRightRelations(Context context, Entity entity) {
        List<Relationship> fullList = entity.getRelationships();
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        for (Relationship relationship : fullList) {
            if (relationship.getRightItem().getID() != entity.getItem().getID()) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<Relationship> getRelationsByLabel(Context context, String label) throws SQLException {
        LinkedList<Relationship> listToReturn = new LinkedList<Relationship>();
        List<Relationship> relationshipList = this.relationshipService.findAll(context);
        for (Relationship relationship : relationshipList) {
            RelationshipType relationshipType = relationship.getRelationshipType();
            if (!StringUtils.equals((CharSequence)relationshipType.getLeftLabel(), (CharSequence)label) && !StringUtils.equals((CharSequence)relationshipType.getRightLabel(), (CharSequence)label)) continue;
            listToReturn.add(relationship);
        }
        return listToReturn;
    }

    @Override
    public List<RelationshipType> getAllRelationshipTypes(Context context, Entity entity) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        LinkedList<RelationshipType> listToReturn = new LinkedList<RelationshipType>();
        for (RelationshipType relationshipType : this.relationshipTypeService.findAll(context)) {
            if (relationshipType.getLeftType().getID() != entityType.getID() && relationshipType.getRightType().getID() != entityType.getID()) continue;
            listToReturn.add(relationshipType);
        }
        return listToReturn;
    }

    @Override
    public List<RelationshipType> getLeftRelationshipTypes(Context context, Entity entity) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        LinkedList<RelationshipType> listToReturn = new LinkedList<RelationshipType>();
        for (RelationshipType relationshipType : this.relationshipTypeService.findAll(context)) {
            if (relationshipType.getLeftType().getID() != entityType.getID()) continue;
            listToReturn.add(relationshipType);
        }
        return listToReturn;
    }

    @Override
    public List<RelationshipType> getRightRelationshipTypes(Context context, Entity entity) throws SQLException {
        EntityType entityType = this.getType(context, entity);
        LinkedList<RelationshipType> listToReturn = new LinkedList<RelationshipType>();
        for (RelationshipType relationshipType : this.relationshipTypeService.findAll(context)) {
            if (relationshipType.getRightType().getID() != entityType.getID()) continue;
            listToReturn.add(relationshipType);
        }
        return listToReturn;
    }

    @Override
    public List<RelationshipType> getRelationshipTypesByLabel(Context context, String label) throws SQLException {
        LinkedList<RelationshipType> listToReturn = new LinkedList<RelationshipType>();
        for (RelationshipType relationshipType : this.relationshipTypeService.findAll(context)) {
            if (!StringUtils.equals((CharSequence)relationshipType.getLeftLabel(), (CharSequence)label) && !StringUtils.equals((CharSequence)relationshipType.getRightLabel(), (CharSequence)label)) continue;
            listToReturn.add(relationshipType);
        }
        return listToReturn;
    }
}

