/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.EntityType;
import org.dspace.content.dao.EntityTypeDAO;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityTypeServiceImpl
implements EntityTypeService {
    @Autowired(required=true)
    protected EntityTypeDAO entityTypeDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;

    @Override
    public EntityType findByEntityType(Context context, String entityType) throws SQLException {
        return this.entityTypeDAO.findByEntityType(context, entityType);
    }

    @Override
    public List<EntityType> findAll(Context context) throws SQLException {
        return this.entityTypeDAO.findAll(context, EntityType.class);
    }

    @Override
    public EntityType create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify entityType");
        }
        return this.entityTypeDAO.create(context, new EntityType());
    }

    @Override
    public EntityType create(Context context, String entityTypeString) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can modify entityType");
        }
        EntityType entityType = new EntityType();
        entityType.setLabel(entityTypeString);
        return this.entityTypeDAO.create(context, entityType);
    }

    @Override
    public EntityType find(Context context, int id) throws SQLException {
        EntityType entityType = (EntityType)this.entityTypeDAO.findByID(context, EntityType.class, id);
        return entityType;
    }

    @Override
    public void update(Context context, EntityType entityType) throws SQLException, AuthorizeException {
        this.update(context, Collections.singletonList(entityType));
    }

    @Override
    public void update(Context context, List<EntityType> entityTypes) throws SQLException, AuthorizeException {
        if (CollectionUtils.isNotEmpty(entityTypes)) {
            if (!this.authorizeService.isAdmin(context)) {
                throw new AuthorizeException("Only administrators can modify entityType");
            }
            for (EntityType entityType : entityTypes) {
                this.entityTypeDAO.save(context, entityType);
            }
        }
    }

    @Override
    public void delete(Context context, EntityType entityType) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can delete entityType");
        }
        this.entityTypeDAO.delete(context, entityType);
    }
}

