/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.Collection;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.AuthorityVariantsSupport;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.InputFormSelfRegisterWrapperAuthority;
import org.dspace.content.authority.SolrAuthority;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.dspace.core.Utils;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public final class ChoiceAuthorityServiceImpl
implements ChoiceAuthorityService {
    private Logger log = LogManager.getLogger(ChoiceAuthorityServiceImpl.class);
    protected Map<String, ChoiceAuthority> controller = new HashMap<String, ChoiceAuthority>();
    protected Map<String, String> presentation = new HashMap<String, String>();
    protected Map<String, Boolean> closed = new HashMap<String, Boolean>();
    protected Map<String, String> authorities = new HashMap<String, String>();
    @Autowired(required=true)
    protected ConfigurationService configurationService;
    @Autowired(required=true)
    protected PluginService pluginService;
    private final String CHOICES_PLUGIN_PREFIX = "choices.plugin.";
    private final String CHOICES_PRESENTATION_PREFIX = "choices.presentation.";
    private final String CHOICES_CLOSED_PREFIX = "choices.closed.";

    protected ChoiceAuthorityServiceImpl() {
    }

    protected String config2fkey(String field) {
        int dot = field.indexOf(46);
        if (dot < 0) {
            return null;
        }
        String schema = field.substring(0, dot);
        String element = field.substring(dot + 1);
        String qualifier = null;
        dot = element.indexOf(46);
        if (dot >= 0) {
            qualifier = element.substring(dot + 1);
            element = element.substring(0, dot);
        }
        return this.makeFieldKey(schema, element, qualifier);
    }

    @Override
    public Set<String> getChoiceAuthoritiesNames() {
        if (this.authorities.keySet().isEmpty()) {
            this.loadChoiceAuthorityConfigurations();
        }
        return this.authorities.keySet();
    }

    @Override
    public Choices getMatches(String schema, String element, String qualifier, String query, Collection collection, int start, int limit, String locale) {
        return this.getMatches(this.makeFieldKey(schema, element, qualifier), query, collection, start, limit, locale);
    }

    @Override
    public Choices getMatches(String fieldKey, String query, Collection collection, int start, int limit, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getMatches(fieldKey, query, collection, start, limit, locale);
    }

    @Override
    public Choices getMatches(String fieldKey, String query, Collection collection, int start, int limit, String locale, boolean externalInput) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        if (externalInput && ma instanceof SolrAuthority) {
            ((SolrAuthority)ma).addExternalResultsInNextMatches();
        }
        return ma.getMatches(fieldKey, query, collection, start, limit, locale);
    }

    @Override
    public Choices getBestMatch(String fieldKey, String query, Collection collection, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getBestMatch(fieldKey, query, collection, locale);
    }

    @Override
    public String getLabel(MetadataValue metadataValue, String locale) {
        return this.getLabel(metadataValue.getMetadataField().toString(), metadataValue.getAuthority(), locale);
    }

    @Override
    public String getLabel(String fieldKey, String authKey, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getLabel(fieldKey, authKey, locale);
    }

    @Override
    public boolean isChoicesConfigured(String fieldKey) {
        return this.getChoiceAuthorityMap().containsKey(fieldKey);
    }

    @Override
    public String getPresentation(String fieldKey) {
        return this.getPresentationMap().get(fieldKey);
    }

    @Override
    public boolean isClosed(String fieldKey) {
        return this.getClosedMap().containsKey(fieldKey) && this.getClosedMap().get(fieldKey) != false;
    }

    @Override
    public List<String> getVariants(MetadataValue metadataValue) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(metadataValue.getMetadataField().toString());
        if (ma instanceof AuthorityVariantsSupport) {
            AuthorityVariantsSupport avs = (AuthorityVariantsSupport)((Object)ma);
            return avs.getVariants(metadataValue.getAuthority(), metadataValue.getLanguage());
        }
        return null;
    }

    @Override
    public String getChoiceAuthorityName(String schema, String element, String qualifier) {
        String makeFieldKey = this.makeFieldKey(schema, element, qualifier);
        if (this.getChoiceAuthorityMap().containsKey(makeFieldKey)) {
            for (String key : this.authorities.keySet()) {
                if (!this.authorities.get(key).equals(makeFieldKey)) continue;
                return key;
            }
        }
        return this.configurationService.getProperty("choices.plugin." + schema + "." + element + (qualifier != null ? "." + qualifier : ""));
    }

    protected String makeFieldKey(String schema, String element, String qualifier) {
        return Utils.standardize(schema, element, qualifier, "_");
    }

    private Map<String, ChoiceAuthority> getChoiceAuthorityMap() {
        if (this.controller.isEmpty()) {
            this.loadChoiceAuthorityConfigurations();
        }
        return this.controller;
    }

    private void loadChoiceAuthorityConfigurations() {
        List propKeys = this.configurationService.getPropertyKeys("choices.plugin.");
        for (String key : propKeys) {
            String fkey = this.config2fkey(key.substring("choices.plugin.".length()));
            if (fkey == null) {
                this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                continue;
            }
            String authorityName = this.configurationService.getProperty(key);
            ChoiceAuthority ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName);
            if (ma == null) {
                this.log.warn("Skipping invalid configuration for " + key + " because named plugin not found: " + authorityName);
                continue;
            }
            if (this.authorities.containsKey(authorityName)) {
                this.log.warn("Skipping invalid configuration for " + key + " because plugin is alredy in use: " + authorityName + " used by " + this.authorities.get(authorityName));
                continue;
            }
            this.controller.put(fkey, ma);
            this.authorities.put(authorityName, fkey);
            this.log.debug("Choice Control: For field=" + fkey + ", Plugin=" + ma);
        }
        this.autoRegisterChoiceAuthorityFromInputReader();
    }

    private void autoRegisterChoiceAuthorityFromInputReader() {
        try {
            DCInputsReader dcInputsReader = new DCInputsReader();
            for (DCInputSet dcinputSet : dcInputsReader.getAllInputs(Integer.MAX_VALUE, 0)) {
                DCInput[][] dcinputs;
                DCInput[][] dCInputArray = dcinputs = dcinputSet.getFields();
                int n = dCInputArray.length;
                for (int i = 0; i < n; ++i) {
                    DCInput[] dcrows;
                    for (DCInput dcinput : dcrows = dCInputArray[i]) {
                        if (!StringUtils.isNotBlank((CharSequence)dcinput.getPairsType()) && !StringUtils.isNotBlank((CharSequence)dcinput.getVocabulary())) continue;
                        String authorityName = dcinput.getPairsType();
                        if (StringUtils.isBlank((CharSequence)authorityName)) {
                            authorityName = dcinput.getVocabulary();
                        }
                        if (StringUtils.equals((CharSequence)dcinput.getInputType(), (CharSequence)"qualdrop_value")) continue;
                        String fieldKey = this.makeFieldKey(dcinput.getSchema(), dcinput.getElement(), dcinput.getQualifier());
                        ChoiceAuthority ca = this.controller.get(authorityName);
                        if (ca == null) {
                            ChoiceAuthority ma;
                            InputFormSelfRegisterWrapperAuthority ifa = new InputFormSelfRegisterWrapperAuthority();
                            if (this.controller.containsKey(fieldKey)) {
                                ifa = (InputFormSelfRegisterWrapperAuthority)this.controller.get(fieldKey);
                            }
                            if ((ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName)) == null) {
                                this.log.warn("Skipping invalid configuration for " + fieldKey + " because named plugin not found: " + authorityName);
                                continue;
                            }
                            ifa.getDelegates().put(dcinputSet.getFormName(), ma);
                            this.controller.put(fieldKey, ifa);
                        }
                        if (this.authorities.containsKey(authorityName)) continue;
                        this.authorities.put(authorityName, fieldKey);
                    }
                }
            }
        }
        catch (DCInputsReaderException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Map<String, String> getPresentationMap() {
        if (this.presentation.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys("choices.presentation.");
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring("choices.presentation.".length()));
                if (fkey == null) {
                    this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                    continue;
                }
                this.presentation.put(fkey, this.configurationService.getProperty(key));
            }
        }
        return this.presentation;
    }

    private Map<String, Boolean> getClosedMap() {
        if (this.closed.isEmpty()) {
            List propKeys = this.configurationService.getPropertyKeys("choices.closed.");
            for (String key : propKeys) {
                String fkey = this.config2fkey(key.substring("choices.closed.".length()));
                if (fkey == null) {
                    this.log.warn("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier");
                    continue;
                }
                this.closed.put(fkey, this.configurationService.getBooleanProperty(key));
            }
        }
        return this.closed;
    }

    @Override
    public String getChoiceMetadatabyAuthorityName(String name) {
        if (this.authorities.isEmpty()) {
            this.loadChoiceAuthorityConfigurations();
        }
        if (this.authorities.containsKey(name)) {
            return this.authorities.get(name);
        }
        return null;
    }

    @Override
    public Choice getChoice(String fieldKey, String authKey, String locale) {
        ChoiceAuthority ma = this.getChoiceAuthorityMap().get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getChoice(fieldKey, authKey, locale);
    }

    @Override
    public ChoiceAuthority getChoiceAuthorityByAuthorityName(String authorityName) {
        ChoiceAuthority ma = (ChoiceAuthority)this.pluginService.getNamedPlugin(ChoiceAuthority.class, authorityName);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for authorityName \"" + authorityName + "\".");
        }
        return ma;
    }
}

