/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import org.dspace.content.authority.Choice;
import org.dspace.content.authority.Choices;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ChoicesXMLGenerator {
    protected static final String NS_URI = "http://www.w3.org/1999/xhtml";
    protected static final String NS_NAME = "";

    private ChoicesXMLGenerator() {
    }

    public static void generate(Choices result, String format, ContentHandler contentHandler) throws SAXException {
        AttributesImpl resultAtts = new AttributesImpl();
        if (result.more) {
            resultAtts.addAttribute(NS_NAME, "more", "more", "boolean", "true");
        }
        if (result.isError()) {
            resultAtts.addAttribute(NS_NAME, "error", "error", "boolean", "true");
        }
        resultAtts.addAttribute(NS_NAME, "start", "start", "int", String.valueOf(result.start));
        resultAtts.addAttribute(NS_NAME, "total", "total", "int", String.valueOf(result.total));
        contentHandler.startDocument();
        if (format != null && format.equalsIgnoreCase("select")) {
            contentHandler.startElement(NS_URI, NS_NAME, "select", resultAtts);
            for (int i = 0; i < result.values.length; ++i) {
                Choice mdav = result.values[i];
                AttributesImpl va = new AttributesImpl();
                va.addAttribute(NS_NAME, "authority", "authority", "string", mdav.authority == null ? NS_NAME : mdav.authority);
                va.addAttribute(NS_NAME, "value", "value", "string", mdav.value);
                if (result.defaultSelected == i) {
                    va.addAttribute(NS_NAME, "selected", "selected", "boolean", NS_NAME);
                }
                contentHandler.startElement(NS_URI, NS_NAME, "option", va);
                contentHandler.characters(mdav.label.toCharArray(), 0, mdav.label.length());
                contentHandler.endElement(NS_URI, NS_NAME, "option");
            }
            contentHandler.endElement(NS_URI, NS_NAME, "select");
        } else if (format != null && format.equalsIgnoreCase("ul")) {
            AttributesImpl classLabel = new AttributesImpl();
            classLabel.addAttribute(NS_NAME, "class", "class", "string", "label");
            AttributesImpl classValue = new AttributesImpl();
            classValue.addAttribute(NS_NAME, "class", "class", "string", "value");
            contentHandler.startElement(NS_URI, NS_NAME, "ul", resultAtts);
            for (int i = 0; i < result.values.length; ++i) {
                Choice mdav = result.values[i];
                AttributesImpl va = new AttributesImpl();
                va.addAttribute(NS_NAME, "authority", "authority", "string", mdav.authority == null ? NS_NAME : mdav.authority);
                if (result.defaultSelected == i) {
                    va.addAttribute(NS_NAME, "selected", "selected", "boolean", NS_NAME);
                }
                contentHandler.startElement(NS_URI, NS_NAME, "li", va);
                contentHandler.startElement(NS_URI, NS_NAME, "span", classLabel);
                contentHandler.characters(mdav.label.toCharArray(), 0, mdav.label.length());
                contentHandler.endElement(NS_URI, NS_NAME, "span");
                contentHandler.startElement(NS_URI, NS_NAME, "span", classValue);
                contentHandler.characters(mdav.value.toCharArray(), 0, mdav.value.length());
                contentHandler.endElement(NS_URI, NS_NAME, "span");
                contentHandler.endElement(NS_URI, NS_NAME, "li");
            }
            contentHandler.endElement(NS_URI, NS_NAME, "ul");
        } else {
            contentHandler.startElement(NS_URI, NS_NAME, "Choices", resultAtts);
            for (int i = 0; i < result.values.length; ++i) {
                Choice mdav = result.values[i];
                AttributesImpl va = new AttributesImpl();
                va.addAttribute(NS_NAME, "authority", "authority", "string", mdav.authority == null ? NS_NAME : mdav.authority);
                va.addAttribute(NS_NAME, "value", "value", "string", mdav.value);
                if (mdav.extras != null) {
                    for (String extraLabel : mdav.extras.keySet()) {
                        va.addAttribute(NS_NAME, extraLabel, extraLabel, "string", mdav.extras.get(extraLabel));
                    }
                }
                if (result.defaultSelected == i) {
                    va.addAttribute(NS_NAME, "selected", "selected", "boolean", NS_NAME);
                }
                contentHandler.startElement(NS_URI, NS_NAME, "Choice", va);
                contentHandler.characters(mdav.label.toCharArray(), 0, mdav.label.length());
                contentHandler.endElement(NS_URI, NS_NAME, "Choice");
            }
            contentHandler.endElement(NS_URI, NS_NAME, "Choices");
        }
        contentHandler.endDocument();
    }
}

