/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.content.Collection;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;

public class InputFormSelfRegisterWrapperAuthority
implements ChoiceAuthority {
    private static Logger log = LogManager.getLogger(InputFormSelfRegisterWrapperAuthority.class);
    private Map<String, ChoiceAuthority> delegates = new HashMap<String, ChoiceAuthority>();
    private static DCInputsReader dci = null;

    private void init() {
        try {
            if (dci == null) {
                dci = new DCInputsReader();
            }
        }
        catch (DCInputsReaderException e) {
            log.error("Failed reading DCInputs initialization: ", (Throwable)e);
        }
    }

    @Override
    public Choices getMatches(String field, String query, Collection collection, int start, int limit, String locale) {
        block5: {
            try {
                this.init();
                if (collection == null) {
                    HashSet<Choice> choices = new HashSet<Choice>();
                    for (ChoiceAuthority ca : this.delegates.values()) {
                        Choices tmp = ca.getMatches(field, query, null, start, limit, locale);
                        if (tmp.total <= 0) continue;
                        HashSet<Choice> mySet = new HashSet<Choice>(Arrays.asList(tmp.values));
                        choices.addAll(mySet);
                    }
                    if (!choices.isEmpty()) {
                        Choice[] results = new Choice[choices.size() - 1];
                        choices.toArray(results);
                        return new Choices(results, 0, choices.size(), 400, false);
                    }
                    break block5;
                }
                String formName = dci.getInputFormNameByCollectionAndField(collection, field);
                return this.delegates.get(formName).getMatches(field, query, collection, start, limit, locale);
            }
            catch (DCInputsReaderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Choices(300);
    }

    @Override
    public Choices getBestMatch(String field, String text, Collection collection, String locale) {
        block5: {
            try {
                this.init();
                if (collection == null) {
                    HashSet<Choice> choices = new HashSet<Choice>();
                    for (ChoiceAuthority ca : this.delegates.values()) {
                        Choices tmp = ca.getBestMatch(field, text, null, locale);
                        if (tmp.total <= 0) continue;
                        HashSet<Choice> mySet = new HashSet<Choice>(Arrays.asList(tmp.values));
                        choices.addAll(mySet);
                    }
                    if (!choices.isEmpty()) {
                        Choice[] results = new Choice[choices.size() - 1];
                        choices.toArray(results);
                        return new Choices(results, 0, choices.size(), 500, false);
                    }
                    break block5;
                }
                String formName = dci.getInputFormNameByCollectionAndField(collection, field);
                return this.delegates.get(formName).getBestMatch(field, text, collection, locale);
            }
            catch (DCInputsReaderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Choices(300);
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        for (ChoiceAuthority delegate : this.delegates.values()) {
            String label = delegate.getLabel(field, key, locale);
            if (!StringUtils.isNotBlank((CharSequence)label)) continue;
            return label;
        }
        return "UNKNOWN KEY " + key;
    }

    @Override
    public boolean isHierarchical() {
        Iterator<ChoiceAuthority> iterator = this.delegates.values().iterator();
        if (iterator.hasNext()) {
            ChoiceAuthority delegate = iterator.next();
            return delegate.isHierarchical();
        }
        return false;
    }

    @Override
    public boolean isScrollable() {
        Iterator<ChoiceAuthority> iterator = this.delegates.values().iterator();
        if (iterator.hasNext()) {
            ChoiceAuthority delegate = iterator.next();
            return delegate.isScrollable();
        }
        return false;
    }

    @Override
    public boolean hasIdentifier() {
        Iterator<ChoiceAuthority> iterator = this.delegates.values().iterator();
        if (iterator.hasNext()) {
            ChoiceAuthority delegate = iterator.next();
            return delegate.hasIdentifier();
        }
        return false;
    }

    public Map<String, ChoiceAuthority> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(Map<String, ChoiceAuthority> delegates) {
        this.delegates = delegates;
    }
}

