/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.authorize.ResourcePolicy_;
import org.dspace.content.Collection;
import org.dspace.content.Collection_;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.dao.CollectionDAO;
import org.dspace.core.AbstractHibernateDSODAO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class CollectionDAOImpl
extends AbstractHibernateDSODAO<Collection>
implements CollectionDAO {
    protected CollectionDAOImpl() {
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order) throws SQLException {
        return this.findAll(context, order, null, null);
    }

    @Override
    public List<Collection> findAll(Context context, MetadataField order, Integer limit, Integer offset) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ").append(Collection.class.getSimpleName()).append(" FROM Collection as ").append(Collection.class.getSimpleName()).append(" ");
        this.addMetadataLeftJoin(query, Collection.class.getSimpleName(), Arrays.asList(order));
        this.addMetadataSortQuery(query, Arrays.asList(order), null);
        Query hibernateQuery = this.createQuery(context, query.toString());
        if (offset != null) {
            hibernateQuery.setFirstResult(offset.intValue());
        }
        if (limit != null) {
            hibernateQuery.setMaxResults(limit.intValue());
        }
        hibernateQuery.setParameter(order.toString(), (Object)order.getID());
        return this.list(hibernateQuery);
    }

    @Override
    public Collection findByTemplateItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.template), (Object)item));
        return this.uniqueResult(context, criteriaQuery, false, Collection.class, -1, -1);
    }

    @Override
    public Collection findByGroup(Context context, Group group) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.submitters), (Object)group), (Expression)criteriaBuilder.equal((Expression)collectionRoot.get(Collection_.admins), (Object)group)));
        return (Collection)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<Collection> findAuthorized(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Collection> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Collection.class);
        Root collectionRoot = criteriaQuery.from(Collection.class);
        Join join = collectionRoot.join("resourcePolicies");
        LinkedList<Predicate> orPredicates = new LinkedList<Predicate>();
        for (Integer action : actions) {
            orPredicates.add(criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.actionId), (Object)action));
        }
        Predicate orPredicate = criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
        criteriaQuery.select((Selection)collectionRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.resourceTypeId), (Object)3), criteriaBuilder.equal((Expression)join.get(ResourcePolicy_.eperson), (Object)ePerson), orPredicate}));
        return this.list(context, criteriaQuery, true, Collection.class, -1, -1);
    }

    @Override
    public List<Collection> findAuthorizedByGroup(Context context, EPerson ePerson, List<Integer> actions) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select c from Collection c join c.resourcePolicies rp join rp.epersonGroup rpGroup WHERE ");
        for (int i = 0; i < actions.size(); ++i) {
            Integer action = actions.get(i);
            if (i != 0) {
                query.append(" AND ");
            }
            query.append("rp.actionId=").append(action);
        }
        query.append(" AND rp.resourceTypeId=").append(3);
        query.append(" AND rp.epersonGroup.id IN (select g.id from Group g where (from EPerson e where e.id = :eperson_id) in elements(epeople))");
        Query persistenceQuery = this.createQuery(context, query.toString());
        persistenceQuery.setParameter("eperson_id", (Object)ePerson.getID());
        persistenceQuery.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(persistenceQuery);
    }

    @Override
    public List<Collection> findCollectionsWithSubscribers(Context context) throws SQLException {
        return this.list(this.createQuery(context, "SELECT DISTINCT col FROM Subscription s join  s.collection col"));
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Collection"));
    }

    @Override
    public List<Map.Entry<Collection, Long>> getCollectionsWithBitstreamSizesTotal(Context context) throws SQLException {
        String q = "select col as collection, sum(bit.sizeBytes) as totalBytes from Item i join i.collections col join i.bundles bun join bun.bitstreams bit group by col";
        Query query = this.createQuery(context, q);
        List list = query.getResultList();
        LinkedList<Map.Entry<Collection, Long>> returnList = new LinkedList<Map.Entry<Collection, Long>>();
        for (Object[] o : list) {
            returnList.add(new AbstractMap.SimpleEntry<Collection, Long>((Collection)o[0], (Long)o[1]));
        }
        return returnList;
    }
}

