/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataField_;
import org.dspace.content.MetadataValue;
import org.dspace.content.dao.MetadataValueDAO;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class MetadataValueDAOImpl
extends AbstractHibernateDAO<MetadataValue>
implements MetadataValueDAO {
    protected MetadataValueDAOImpl() {
    }

    @Override
    public List<MetadataValue> findByField(Context context, MetadataField metadataField) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MetadataValue> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MetadataValue.class);
        Root metadataValueRoot = criteriaQuery.from(MetadataValue.class);
        Join join = metadataValueRoot.join("metadataField");
        criteriaQuery.select((Selection)metadataValueRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)join.get(MetadataField_.id), (Object)metadataField.getID()));
        return this.list(context, criteriaQuery, false, MetadataValue.class, -1, -1);
    }

    @Override
    public Iterator<MetadataValue> findByValueLike(Context context, String value) throws SQLException {
        String queryString = "SELECT m FROM MetadataValue m JOIN m.metadataField f WHERE m.value like concat('%', concat(:searchString,'%')) ORDER BY m.id ASC";
        Query query = this.createQuery(context, queryString);
        query.setParameter("searchString", (Object)value);
        return this.iterate(query);
    }

    @Override
    public void deleteByMetadataField(Context context, MetadataField metadataField) throws SQLException {
        String queryString = "delete from MetadataValue where metadataField= :metadataField";
        Query query = this.createQuery(context, queryString);
        query.setParameter("metadataField", (Object)metadataField);
        query.executeUpdate();
    }

    @Override
    public MetadataValue getMinimum(Context context, int metadataFieldId) throws SQLException {
        String queryString = "SELECT m FROM MetadataValue m JOIN FETCH m.metadataField WHERE m.metadataField.id = :metadata_field_id ORDER BY text_value";
        Query query = this.createQuery(context, queryString);
        query.setParameter("metadata_field_id", (Object)metadataFieldId);
        query.setMaxResults(1);
        return (MetadataValue)query.getSingleResult();
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM MetadataValue"));
    }
}

