/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.virtual;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.virtual.VirtualMetadataConfiguration;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;

public class Related
implements VirtualMetadataConfiguration {
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private EntityService entityService;
    private String relationshipTypeString;
    private Integer place;
    private VirtualMetadataConfiguration virtualMetadataConfiguration;
    private boolean useForPlace = false;

    public String getRelationshipTypeString() {
        return this.relationshipTypeString;
    }

    public void setRelationshipTypeString(String relationshipTypeString) {
        this.relationshipTypeString = relationshipTypeString;
    }

    public Integer getPlace() {
        return this.place;
    }

    public void setPlace(Integer place) {
        this.place = place;
    }

    public VirtualMetadataConfiguration getVirtualMetadataConfiguration() {
        return this.virtualMetadataConfiguration;
    }

    public void setVirtualMetadataConfiguration(VirtualMetadataConfiguration virtualMetadataConfiguration) {
        this.virtualMetadataConfiguration = virtualMetadataConfiguration;
    }

    @Override
    public void setUseForPlace(boolean useForPlace) {
        this.useForPlace = useForPlace;
    }

    @Override
    public boolean getUseForPlace() {
        return this.useForPlace;
    }

    @Override
    public List<String> getValues(Context context, Item item) throws SQLException {
        Entity entity = this.entityService.findByItemId(context, item.getID());
        EntityType entityType = this.entityService.getType(context, entity);
        List<RelationshipType> relationshipTypes = this.entityService.getAllRelationshipTypes(context, entity);
        LinkedList<RelationshipType> possibleRelationshipTypes = new LinkedList<RelationshipType>();
        for (RelationshipType relationshipType : relationshipTypes) {
            if (!StringUtils.equals((CharSequence)relationshipType.getLeftLabel(), (CharSequence)this.relationshipTypeString) && !StringUtils.equals((CharSequence)relationshipType.getRightLabel(), (CharSequence)this.relationshipTypeString)) continue;
            possibleRelationshipTypes.add(relationshipType);
        }
        LinkedList<Relationship> relationships = new LinkedList<Relationship>();
        for (RelationshipType relationshipType : possibleRelationshipTypes) {
            relationships.addAll(this.relationshipService.findByItemAndRelationshipType(context, item, relationshipType));
        }
        for (Relationship relationship : relationships) {
            if (relationship.getRelationshipType().getLeftType() == entityType) {
                if (relationship.getLeftPlace() != this.place.intValue()) continue;
                Item otherItem = relationship.getRightItem();
                return this.virtualMetadataConfiguration.getValues(context, otherItem);
            }
            if (relationship.getRelationshipType().getRightType() != entityType || relationship.getRightPlace() != this.place.intValue()) continue;
            Item otherItem = relationship.getLeftItem();
            return this.virtualMetadataConfiguration.getValues(context, otherItem);
        }
        return new LinkedList<String>();
    }
}

