/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.IndexableObject;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrServiceSpellIndexingPlugin
implements SolrServiceIndexPlugin {
    @Autowired(required=true)
    protected ItemService itemService;

    @Override
    public void additionalIndex(Context context, IndexableObject dso, SolrInputDocument document) {
        if (dso instanceof Item) {
            Item item = (Item)dso;
            List<MetadataValue> dcValues = this.itemService.getMetadata(item, "*", "*", "*", "*");
            List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(item.getType());
            for (MetadataValue dcValue : dcValues) {
                if (toIgnoreMetadataFields.contains(dcValue.getMetadataField().toString('.'))) continue;
                document.addField("a_spell", (Object)dcValue.getValue());
            }
        }
    }
}

