/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.discovery.configuration.DiscoveryConfigurationException;
import org.dspace.discovery.configuration.DiscoveryHitHighlightingConfiguration;
import org.dspace.discovery.configuration.DiscoveryMoreLikeThisConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.TagCloudFacetConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class DiscoveryConfiguration
implements InitializingBean {
    private List<DiscoverySearchFilterFacet> sidebarFacets = new ArrayList<DiscoverySearchFilterFacet>();
    private TagCloudFacetConfiguration tagCloudFacetConfiguration = new TagCloudFacetConfiguration();
    private List<String> defaultFilterQueries;
    private DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration;
    private List<DiscoverySearchFilter> searchFilters = new ArrayList<DiscoverySearchFilter>();
    private DiscoverySortConfiguration searchSortConfiguration;
    private int defaultRpp = 10;
    private String id;
    private DiscoveryHitHighlightingConfiguration hitHighlightingConfiguration;
    private DiscoveryMoreLikeThisConfiguration moreLikeThisConfiguration;
    private boolean spellCheckEnabled;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<DiscoverySearchFilterFacet> getSidebarFacets() {
        return this.sidebarFacets;
    }

    @Required
    public void setSidebarFacets(List<DiscoverySearchFilterFacet> sidebarFacets) {
        this.sidebarFacets = sidebarFacets;
    }

    public TagCloudFacetConfiguration getTagCloudFacetConfiguration() {
        return this.tagCloudFacetConfiguration;
    }

    public void setTagCloudFacetConfiguration(TagCloudFacetConfiguration tagCloudFacetConfiguration) {
        this.tagCloudFacetConfiguration = tagCloudFacetConfiguration;
    }

    public List<String> getDefaultFilterQueries() {
        if (this.defaultFilterQueries == null) {
            return new ArrayList<String>();
        }
        return this.defaultFilterQueries;
    }

    public void setDefaultFilterQueries(List<String> defaultFilterQueries) {
        this.defaultFilterQueries = defaultFilterQueries;
    }

    public DiscoveryRecentSubmissionsConfiguration getRecentSubmissionConfiguration() {
        return this.recentSubmissionConfiguration;
    }

    public void setRecentSubmissionConfiguration(DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration) {
        this.recentSubmissionConfiguration = recentSubmissionConfiguration;
    }

    public List<DiscoverySearchFilter> getSearchFilters() {
        return this.searchFilters;
    }

    public DiscoverySearchFilter getSearchFilter(String name) {
        for (DiscoverySearchFilter filter : CollectionUtils.emptyIfNull(this.searchFilters)) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)filter.getIndexFieldName())) continue;
            return filter;
        }
        return null;
    }

    @Required
    public void setSearchFilters(List<DiscoverySearchFilter> searchFilters) {
        this.searchFilters = searchFilters;
    }

    public DiscoverySortConfiguration getSearchSortConfiguration() {
        return this.searchSortConfiguration;
    }

    @Required
    public void setSearchSortConfiguration(DiscoverySortConfiguration searchSortConfiguration) {
        this.searchSortConfiguration = searchSortConfiguration;
    }

    public void setDefaultRpp(int defaultRpp) {
        this.defaultRpp = defaultRpp;
    }

    public int getDefaultRpp() {
        return this.defaultRpp;
    }

    public void setHitHighlightingConfiguration(DiscoveryHitHighlightingConfiguration hitHighlightingConfiguration) {
        this.hitHighlightingConfiguration = hitHighlightingConfiguration;
    }

    public DiscoveryHitHighlightingConfiguration getHitHighlightingConfiguration() {
        return this.hitHighlightingConfiguration;
    }

    public void setMoreLikeThisConfiguration(DiscoveryMoreLikeThisConfiguration moreLikeThisConfiguration) {
        this.moreLikeThisConfiguration = moreLikeThisConfiguration;
    }

    public DiscoveryMoreLikeThisConfiguration getMoreLikeThisConfiguration() {
        return this.moreLikeThisConfiguration;
    }

    public boolean isSpellCheckEnabled() {
        return this.spellCheckEnabled;
    }

    public void setSpellCheckEnabled(boolean spellCheckEnabled) {
        this.spellCheckEnabled = spellCheckEnabled;
    }

    public void afterPropertiesSet() throws Exception {
        Collection missingSearchFilters = CollectionUtils.subtract(this.getSidebarFacets(), this.getSearchFilters());
        if (CollectionUtils.isNotEmpty((Collection)missingSearchFilters)) {
            StringBuilder error = new StringBuilder();
            error.append("The following sidebar facet configurations are not present in the search filters list: ");
            for (Object missingSearchFilter : missingSearchFilters) {
                DiscoverySearchFilter searchFilter = (DiscoverySearchFilter)missingSearchFilter;
                error.append(searchFilter.getIndexFieldName()).append(" ");
            }
            error.append("all the sidebar facets MUST be a part of the search filters list.");
            throw new DiscoveryConfigurationException(error.toString());
        }
        Collection missingTagCloudSearchFilters = CollectionUtils.subtract(this.getTagCloudFacetConfiguration().getTagCloudFacets(), this.getSearchFilters());
        if (CollectionUtils.isNotEmpty((Collection)missingTagCloudSearchFilters)) {
            StringBuilder error = new StringBuilder();
            error.append("The following tagCloud facet configurations are not present in the search filters list: ");
            for (Object missingSearchFilter : missingTagCloudSearchFilters) {
                DiscoverySearchFilter searchFilter = (DiscoverySearchFilter)missingSearchFilter;
                error.append(searchFilter.getIndexFieldName()).append(" ");
            }
            error.append("all the tagCloud facets MUST be a part of the search filters list.");
            throw new DiscoveryConfigurationException(error.toString());
        }
    }

    public DiscoverySearchFilterFacet getSidebarFacet(String facetName) {
        for (DiscoverySearchFilterFacet sidebarFacet : this.sidebarFacets) {
            if (!StringUtils.equals((CharSequence)sidebarFacet.getIndexFieldName(), (CharSequence)facetName)) continue;
            return sidebarFacet;
        }
        return null;
    }
}

