/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.dspace.eperson.dao.EPersonDAO;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.event.Event;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EPersonServiceImpl
extends DSpaceObjectServiceImpl<EPerson>
implements EPersonService {
    private final Logger log = LogManager.getLogger(EPersonServiceImpl.class);
    @Autowired(required=true)
    protected EPersonDAO ePersonDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected SubscribeService subscribeService;

    protected EPersonServiceImpl() {
    }

    @Override
    public EPerson find(Context context, UUID id) throws SQLException {
        return (EPerson)this.ePersonDAO.findByID(context, EPerson.class, id);
    }

    @Override
    public EPerson findByIdOrLegacyId(Context context, String id) throws SQLException {
        if (StringUtils.isNumeric((CharSequence)id)) {
            return this.findByLegacyId(context, Integer.parseInt(id));
        }
        return this.find(context, UUID.fromString(id));
    }

    @Override
    public EPerson findByLegacyId(Context context, int legacyId) throws SQLException {
        return this.ePersonDAO.findByLegacyId(context, legacyId, EPerson.class);
    }

    @Override
    public EPerson findByEmail(Context context, String email) throws SQLException {
        if (email == null) {
            return null;
        }
        return this.ePersonDAO.findByEmail(context, email);
    }

    @Override
    public EPerson findByNetid(Context context, String netId) throws SQLException {
        if (netId == null) {
            return null;
        }
        return this.ePersonDAO.findByNetid(context, netId);
    }

    @Override
    public List<EPerson> search(Context context, String query) throws SQLException {
        if (StringUtils.isBlank((CharSequence)query)) {
            return this.findAll(context, 1);
        }
        return this.search(context, query, -1, -1);
    }

    @Override
    public List<EPerson> search(Context context, String query, int offset, int limit) throws SQLException {
        try {
            ArrayList<EPerson> ePerson = new ArrayList<EPerson>();
            EPerson person = this.find(context, UUID.fromString(query));
            if (person != null) {
                ePerson.add(person);
            }
            return ePerson;
        }
        catch (IllegalArgumentException e) {
            MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
            MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            if (StringUtils.isBlank((CharSequence)query)) {
                query = null;
            }
            return this.ePersonDAO.search(context, query, Arrays.asList(firstNameField, lastNameField), Arrays.asList(firstNameField, lastNameField), offset, limit);
        }
    }

    @Override
    public int searchResultCount(Context context, String query) throws SQLException {
        MetadataField firstNameField = this.metadataFieldService.findByElement(context, "eperson", "firstname", null);
        MetadataField lastNameField = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
        if (StringUtils.isBlank((CharSequence)query)) {
            query = null;
        }
        return this.ePersonDAO.searchResultCount(context, query, Arrays.asList(firstNameField, lastNameField));
    }

    @Override
    public List<EPerson> findAll(Context context, int sortField) throws SQLException {
        return this.findAll(context, sortField, -1, -1);
    }

    @Override
    public List<EPerson> findAll(Context context, int sortField, int pageSize, int offset) throws SQLException {
        String sortColumn = null;
        MetadataField metadataFieldSort = null;
        switch (sortField) {
            case 3: {
                sortColumn = "eperson_id";
                break;
            }
            case 1: {
                sortColumn = "email";
                break;
            }
            case 5: {
                metadataFieldSort = this.metadataFieldService.findByElement(context, "eperson", "language", null);
                break;
            }
            case 4: {
                sortColumn = "netid";
                break;
            }
            default: {
                metadataFieldSort = this.metadataFieldService.findByElement(context, "eperson", "lastname", null);
            }
        }
        return this.ePersonDAO.findAll(context, metadataFieldSort, sortColumn, pageSize, offset);
    }

    @Override
    public EPerson create(Context context) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson");
        }
        EPerson e = this.ePersonDAO.create(context, new EPerson());
        this.log.info(org.dspace.core.LogManager.getHeader(context, "create_eperson", "eperson_id=" + e.getID()));
        context.addEvent(new Event(1, 7, e.getID(), null, this.getIdentifiers(context, e)));
        return e;
    }

    @Override
    public void delete(Context context, EPerson ePerson) throws SQLException, AuthorizeException {
        if (!this.authorizeService.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to delete an EPerson");
        }
        List<String> constraintList = this.getDeleteConstraints(context, ePerson);
        if (constraintList.size() > 0) {
            throw new AuthorizeException(new EPersonDeletionException(constraintList));
        }
        context.addEvent(new Event(32, 7, ePerson.getID(), ePerson.getEmail(), this.getIdentifiers(context, ePerson)));
        Iterator<Group> groups = ePerson.getGroups().iterator();
        while (groups.hasNext()) {
            Group group = groups.next();
            groups.remove();
            group.getMembers().remove(ePerson);
        }
        this.subscribeService.deleteByEPerson(context, ePerson);
        this.ePersonDAO.delete(context, ePerson);
        this.log.info(org.dspace.core.LogManager.getHeader(context, "delete_eperson", "eperson_id=" + ePerson.getID()));
    }

    @Override
    public int getSupportsTypeConstant() {
        return 7;
    }

    @Override
    public void setPassword(EPerson ePerson, String password) {
        PasswordHash hash = new PasswordHash(password);
        ePerson.setDigestAlgorithm(hash.getAlgorithm());
        ePerson.setSalt(Utils.toHex(hash.getSalt()));
        ePerson.setPassword(Utils.toHex(hash.getHash()));
    }

    @Override
    public void setPasswordHash(EPerson ePerson, PasswordHash password) {
        if (null == password) {
            ePerson.setDigestAlgorithm(null);
            ePerson.setSalt(null);
            ePerson.setPassword(null);
        } else {
            ePerson.setDigestAlgorithm(password.getAlgorithm());
            ePerson.setSalt(password.getSaltString());
            ePerson.setPassword(password.getHashString());
        }
    }

    @Override
    public PasswordHash getPasswordHash(EPerson ePerson) {
        PasswordHash hash = null;
        try {
            hash = new PasswordHash(ePerson.getDigestAlgorithm(), ePerson.getSalt(), ePerson.getPassword());
        }
        catch (DecoderException ex) {
            this.log.error("Problem decoding stored salt or hash:  " + ex.getMessage());
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPassword(Context context, EPerson ePerson, String attempt) {
        PasswordHash myHash;
        try {
            myHash = new PasswordHash(ePerson.getDigestAlgorithm(), ePerson.getSalt(), ePerson.getPassword());
        }
        catch (DecoderException ex) {
            this.log.error(ex.getMessage());
            return false;
        }
        boolean answer = myHash.matches(attempt);
        if (answer && null == ePerson.getDigestAlgorithm()) {
            this.log.info("Upgrading password hash for EPerson " + ePerson.getID());
            this.setPassword(ePerson, attempt);
            try {
                context.turnOffAuthorisationSystem();
                this.update(context, ePerson);
            }
            catch (SQLException | AuthorizeException ex) {
                this.log.error("Could not update password hash", (Throwable)ex);
            }
            finally {
                context.restoreAuthSystemState();
            }
        }
        return answer;
    }

    @Override
    public void update(Context context, EPerson ePerson) throws SQLException, AuthorizeException {
        if (!(context.ignoreAuthorization() || context.getCurrentUser() != null && ePerson.getID() == context.getCurrentUser().getID())) {
            this.authorizeService.authorizeAction(context, ePerson, 1);
        }
        super.update(context, ePerson);
        this.ePersonDAO.save(context, ePerson);
        this.log.info(org.dspace.core.LogManager.getHeader(context, "update_eperson", "eperson_id=" + ePerson.getID()));
        if (ePerson.isModified()) {
            context.addEvent(new Event(2, 7, ePerson.getID(), null, this.getIdentifiers(context, ePerson)));
            ePerson.clearModified();
        }
        if (ePerson.isMetadataModified()) {
            ePerson.clearDetails();
        }
    }

    @Override
    public List<String> getDeleteConstraints(Context context, EPerson ePerson) throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        Iterator<Item> itemsBySubmitter = this.itemService.findBySubmitter(context, ePerson);
        if (itemsBySubmitter.hasNext()) {
            tableList.add("item");
        }
        WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
        List<String> workflowConstraints = workflowService.getEPersonDeleteConstraints(context, ePerson);
        tableList.addAll(workflowConstraints);
        return tableList;
    }

    @Override
    public List<EPerson> findByGroups(Context c, Set<Group> groups) throws SQLException {
        if (CollectionUtils.isNotEmpty(groups)) {
            return this.ePersonDAO.findByGroups(c, groups);
        }
        return new ArrayList<EPerson>();
    }

    @Override
    public List<EPerson> findEPeopleWithSubscription(Context context) throws SQLException {
        return this.ePersonDAO.findAllSubscribers(context);
    }

    @Override
    public void updateLastModified(Context context, EPerson dso) throws SQLException {
    }

    @Override
    public String getMetadata(EPerson dso, String field) {
        String[] MDValue = this.getMDValueByLegacyField(field);
        return this.getMetadataFirstValue(dso, MDValue[0], MDValue[1], MDValue[2], "*");
    }

    @Override
    public void setMetadata(Context context, EPerson ePerson, String field, String value) throws SQLException {
        String[] MDValue = this.getMDValueByLegacyField(field);
        this.setMetadataSingleValue(context, ePerson, MDValue[0], MDValue[1], MDValue[2], null, value);
    }

    @Override
    public List<EPerson> findUnsalted(Context context) throws SQLException {
        return this.ePersonDAO.findWithPasswordWithoutDigestAlgorithm(context);
    }

    @Override
    public List<EPerson> findNotActiveSince(Context context, Date date) throws SQLException {
        return this.ePersonDAO.findNotActiveSince(context, date);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.ePersonDAO.countRows(context);
    }
}

