/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.health;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.dspace.app.util.CollectionDropDown;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.health.Check;
import org.dspace.health.ReportInfo;
import org.dspace.workflowbasic.factory.BasicWorkflowServiceFactory;
import org.dspace.workflowbasic.service.BasicWorkflowItemService;

public class ItemCheck
extends Check {
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    private CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private BasicWorkflowItemService basicWorkflowItemService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowItemService();
    private HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();

    @Override
    public String run(ReportInfo ri) {
        String ret = "";
        int tot_cnt = 0;
        Context context = new Context();
        try {
            for (Map.Entry<String, Integer> name_count : this.getCommunities(context)) {
                ret = ret + String.format("Community [%s]: %d\n", name_count.getKey(), name_count.getValue());
                tot_cnt += name_count.getValue().intValue();
            }
        }
        catch (SQLException e) {
            this.error(e);
        }
        try {
            ret = ret + "\nCollection sizes:\n";
            ret = ret + this.getCollectionSizesInfo(context);
        }
        catch (SQLException e) {
            this.error(e);
        }
        ret = ret + String.format("\nPublished items (archived, not withdrawn): %d\n", tot_cnt);
        try {
            ret = ret + String.format("Withdrawn items: %d\n", this.itemService.countWithdrawnItems(context));
            ret = ret + String.format("Not published items (in workspace or workflow mode): %d\n", this.itemService.countNotArchivedItems(context));
            for (Map.Entry<Integer, Long> row : this.workspaceItemService.getStageReachedCounts(context)) {
                ret = ret + String.format("\tIn Stage %s: %s\n", row.getKey(), row.getValue());
            }
            ret = ret + String.format("\tWaiting for approval (workflow items): %d\n", this.basicWorkflowItemService.countTotal(context));
        }
        catch (SQLException e) {
            this.error(e);
        }
        try {
            ret = ret + this.getObjectSizesInfo(context);
            context.complete();
        }
        catch (SQLException e) {
            this.error(e);
        }
        return ret;
    }

    public String getObjectSizesInfo(Context context) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Count %-14s: %s\n", "Bitstream", String.valueOf(this.bitstreamService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Bundle", String.valueOf(this.bundleService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Collection", String.valueOf(this.collectionService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Community", String.valueOf(this.communityService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "MetadataValue", String.valueOf(this.metadataValueService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "EPerson", String.valueOf(this.ePersonService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Item", String.valueOf(this.itemService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Handle", String.valueOf(this.handleService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "Group", String.valueOf(this.groupService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "BasicWorkflowItem", String.valueOf(this.basicWorkflowItemService.countTotal(context))));
        sb.append(String.format("Count %-14s: %s\n", "WorkspaceItem", String.valueOf(this.workspaceItemService.countTotal(context))));
        return sb.toString();
    }

    public String getCollectionSizesInfo(final Context context) throws SQLException {
        final StringBuffer ret = new StringBuffer();
        List<Map.Entry<Collection, Long>> colBitSizes = this.collectionService.getCollectionsWithBitstreamSizesTotal(context);
        long total_size = 0L;
        Collections.sort(colBitSizes, new Comparator<Map.Entry<Collection, Long>>(){

            @Override
            public int compare(Map.Entry<Collection, Long> o1, Map.Entry<Collection, Long> o2) {
                try {
                    return CollectionDropDown.collectionPath(context, o1.getKey()).compareTo(CollectionDropDown.collectionPath(context, o2.getKey()));
                }
                catch (Exception e) {
                    ret.append(e.getMessage());
                    return 0;
                }
            }
        });
        for (Map.Entry<Collection, Long> row : colBitSizes) {
            Long size = row.getValue();
            total_size += size.longValue();
            Collection col = row.getKey();
            ret.append(String.format("\t%s:  %s\n", CollectionDropDown.collectionPath(context, col), FileUtils.byteCountToDisplaySize((long)size)));
        }
        ret.append(String.format("Total size:              %s\n", FileUtils.byteCountToDisplaySize((long)total_size)));
        ret.append(String.format("Resource without policy: %d\n", this.bitstreamService.countBitstreamsWithoutPolicy(context)));
        ret.append(String.format("Deleted bitstreams:      %d\n", this.bitstreamService.countDeletedBitstreams(context)));
        String list_str = "";
        List<Bitstream> bitstreamOrphans = this.bitstreamService.getNotReferencedBitstreams(context);
        for (Bitstream orphan : bitstreamOrphans) {
            UUID id = orphan.getID();
            list_str = list_str + String.format("%s, ", id);
        }
        ret.append(String.format("Orphan bitstreams:       %d [%s]\n", bitstreamOrphans.size(), list_str));
        return ret.toString();
    }

    public List<Map.Entry<String, Integer>> getCommunities(Context context) throws SQLException {
        ArrayList<Map.Entry<String, Integer>> cl = new ArrayList<Map.Entry<String, Integer>>();
        List<Community> top_communities = this.communityService.findAllTop(context);
        for (Community c : top_communities) {
            cl.add(new AbstractMap.SimpleEntry<String, Integer>(c.getName(), this.itemService.countItems(context, c)));
        }
        return cl;
    }
}

