/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.springframework.beans.factory.annotation.Autowired;

public class SiteServiceInitializer
implements FlywayCallback {
    private Logger log = LogManager.getLogger(SiteServiceInitializer.class);
    @Autowired(required=true)
    protected SiteService siteService;

    public void initializeSiteObject() {
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            if (this.siteService.findSite(context) == null) {
                this.siteService.createSite(context);
            }
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            this.log.error("Error attempting to add/update default DSpace Groups", (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public void beforeClean(Connection connection) {
    }

    public void afterClean(Connection connection) {
    }

    public void beforeMigrate(Connection connection) {
    }

    public void afterMigrate(Connection connection) {
        this.initializeSiteObject();
    }

    public void beforeEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void afterEachMigrate(Connection connection, MigrationInfo migrationInfo) {
    }

    public void beforeValidate(Connection connection) {
    }

    public void afterValidate(Connection connection) {
    }

    public void beforeBaseline(Connection connection) {
    }

    public void afterBaseline(Connection connection) {
    }

    public void beforeRepair(Connection connection) {
    }

    public void afterRepair(Connection connection) {
    }

    public void beforeInfo(Connection connection) {
    }

    public void afterInfo(Connection connection) {
    }
}

