/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.dao.XmlWorkflowItemDAO;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.dspace.xmlworkflow.storedcomponents.service.WorkflowItemRoleService;
import org.dspace.xmlworkflow.storedcomponents.service.XmlWorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class XmlWorkflowItemServiceImpl
implements XmlWorkflowItemService {
    @Autowired(required=true)
    protected XmlWorkflowItemDAO xmlWorkflowItemDAO;
    @Autowired(required=true)
    protected ClaimedTaskService claimedTaskService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected PoolTaskService poolTaskService;
    @Autowired(required=true)
    protected WorkflowRequirementsService workflowRequirementsService;
    @Autowired(required=true)
    protected WorkflowItemRoleService workflowItemRoleService;
    private Logger log = LogManager.getLogger(XmlWorkflowItemServiceImpl.class);

    protected XmlWorkflowItemServiceImpl() {
    }

    @Override
    public int getSupportsIndexableObjectTypeConstant() {
        return 9;
    }

    @Override
    public XmlWorkflowItem create(Context context, Item item, Collection collection) throws SQLException, AuthorizeException {
        XmlWorkflowItem xmlWorkflowItem = this.xmlWorkflowItemDAO.create(context, new XmlWorkflowItem());
        xmlWorkflowItem.setItem(item);
        xmlWorkflowItem.setCollection(collection);
        return xmlWorkflowItem;
    }

    @Override
    public XmlWorkflowItem find(Context context, int id) throws SQLException {
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowItemDAO.findByID(context, XmlWorkflowItem.class, id);
        if (workflowItem == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(org.dspace.core.LogManager.getHeader(context, "find_workflow_item", "not_found,workflowitem_id=" + id));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug(org.dspace.core.LogManager.getHeader(context, "find_workflow_item", "workflowitem_id=" + id));
        }
        return workflowItem;
    }

    @Override
    public XmlWorkflowItem findIndexableObject(Context context, Integer id) throws SQLException {
        if (id != null) {
            return this.find(context, id);
        }
        return null;
    }

    @Override
    public List<XmlWorkflowItem> findAll(Context context) throws SQLException {
        return this.xmlWorkflowItemDAO.findAll(context, XmlWorkflowItem.class);
    }

    @Override
    public List<XmlWorkflowItem> findAll(Context context, Integer page, Integer pagesize) throws SQLException {
        return this.findAllInCollection(context, page, pagesize, null);
    }

    @Override
    public List<XmlWorkflowItem> findAllInCollection(Context context, Integer page, Integer pagesize, Collection collection) throws SQLException {
        Integer offset = null;
        if (page != null && pagesize != null) {
            offset = page * pagesize;
        }
        return this.xmlWorkflowItemDAO.findAllInCollection(context, offset, pagesize, collection);
    }

    @Override
    public int countAll(Context context) throws SQLException {
        return this.xmlWorkflowItemDAO.countAll(context);
    }

    @Override
    public int countAllInCollection(Context context, Collection collection) throws SQLException {
        return this.xmlWorkflowItemDAO.countAllInCollection(context, collection);
    }

    @Override
    public List<XmlWorkflowItem> findBySubmitter(Context context, EPerson ep) throws SQLException {
        return this.xmlWorkflowItemDAO.findBySubmitter(context, ep);
    }

    @Override
    public List<XmlWorkflowItem> findBySubmitter(Context context, EPerson ep, Integer pageNumber, Integer pageSize) throws SQLException {
        Integer offset = null;
        if (pageNumber != null && pageSize != null) {
            offset = pageNumber * pageSize;
        }
        return this.xmlWorkflowItemDAO.findBySubmitter(context, ep, pageNumber, pageSize);
    }

    @Override
    public int countBySubmitter(Context context, EPerson ep) throws SQLException {
        return this.xmlWorkflowItemDAO.countBySubmitter(context, ep);
    }

    @Override
    public void deleteByCollection(Context context, Collection collection) throws SQLException, IOException, AuthorizeException {
        List<XmlWorkflowItem> xmlWorkflowItems = this.findByCollection(context, collection);
        Iterator<XmlWorkflowItem> iterator = xmlWorkflowItems.iterator();
        while (iterator.hasNext()) {
            XmlWorkflowItem workflowItem = iterator.next();
            iterator.remove();
            this.delete(context, workflowItem);
        }
    }

    @Override
    public void delete(Context context, XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException, IOException {
        Item item = workflowItem.getItem();
        this.deleteWrapper(context, workflowItem);
        this.itemService.delete(context, item);
    }

    @Override
    public List<XmlWorkflowItem> findByCollection(Context context, Collection collection) throws SQLException {
        return this.xmlWorkflowItemDAO.findByCollection(context, collection);
    }

    @Override
    public XmlWorkflowItem findByItem(Context context, Item item) throws SQLException {
        return this.xmlWorkflowItemDAO.findByItem(context, item);
    }

    @Override
    public void update(Context context, XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException {
        this.log.info(org.dspace.core.LogManager.getHeader(context, "update_workflow_item", "workflowitem_id=" + workflowItem.getID()));
        this.itemService.update(context, workflowItem.getItem());
        this.xmlWorkflowItemDAO.save(context, workflowItem);
    }

    @Override
    public void deleteWrapper(Context context, XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException {
        List<WorkflowItemRole> roles = this.workflowItemRoleService.findByWorkflowItem(context, workflowItem);
        Iterator<WorkflowItemRole> workflowItemRoleIterator = roles.iterator();
        while (workflowItemRoleIterator.hasNext()) {
            WorkflowItemRole workflowItemRole = workflowItemRoleIterator.next();
            workflowItemRoleIterator.remove();
            this.workflowItemRoleService.delete(context, workflowItemRole);
        }
        this.poolTaskService.deleteByWorkflowItem(context, workflowItem);
        this.workflowRequirementsService.clearInProgressUsers(context, workflowItem);
        this.claimedTaskService.deleteByWorkflowItem(context, workflowItem);
        this.xmlWorkflowItemDAO.delete(context, workflowItem);
    }

    @Override
    public void move(Context context, XmlWorkflowItem inProgressSubmission, Collection fromCollection, Collection toCollection) {
    }
}

