/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class EPersonBuilder
extends AbstractDSpaceObjectBuilder<EPerson> {
    private static final Logger LOG = LogManager.getLogger(EPersonBuilder.class);
    private EPerson ePerson;

    protected EPersonBuilder(Context context) {
        super(context);
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.ePerson = (EPerson)c.reloadEntity((ReloadableEntity)this.ePerson);
            if (this.ePerson != null) {
                this.delete(c, this.ePerson);
                c.complete();
            }
        }
    }

    @Override
    protected DSpaceObjectService<EPerson> getService() {
        return ePersonService;
    }

    @Override
    public EPerson build() {
        try {
            ePersonService.update(this.context, (DSpaceObject)this.ePerson);
            indexingService.commit();
        }
        catch (SQLException | AuthorizeException | SearchServiceException e) {
            LOG.warn("Failed to complete the EPerson", e);
        }
        return this.ePerson;
    }

    public static EPersonBuilder createEPerson(Context context) {
        EPersonBuilder ePersonBuilder = new EPersonBuilder(context);
        return ePersonBuilder.create();
    }

    private EPersonBuilder create() {
        try {
            this.ePerson = ePersonService.create(this.context);
        }
        catch (SQLException | AuthorizeException e) {
            LOG.warn("Failed to create the EPerson", e);
        }
        return this;
    }

    public EPersonBuilder withNameInMetadata(String firstName, String lastName) throws SQLException {
        this.ePerson.setFirstName(this.context, firstName);
        this.ePerson.setLastName(this.context, lastName);
        return this;
    }

    public EPersonBuilder withEmail(String name) {
        this.ePerson.setEmail(name);
        return this;
    }

    public EPersonBuilder withLanguage(String lang) throws SQLException {
        this.ePerson.setLanguage(this.context, lang);
        return this;
    }

    public EPersonBuilder withPhone(String phone) throws SQLException {
        ePersonService.setMetadataSingleValue(this.context, (DSpaceObject)this.ePerson, "eperson", "phone", null, null, phone);
        return this;
    }

    public EPersonBuilder withGroupMembership(Group group) {
        groupService.addMember(this.context, group, this.ePerson);
        return this;
    }

    public EPersonBuilder withNetId(String netId) {
        this.ePerson.setNetid(netId);
        return this;
    }

    public EPersonBuilder withPassword(String password) {
        this.ePerson.setCanLogIn(true);
        ePersonService.setPassword(this.ePerson, password);
        return this;
    }

    public EPersonBuilder withCanLogin(boolean canLogin) {
        this.ePerson.setCanLogIn(canLogin);
        return this;
    }

    public static void deleteEPerson(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            EPerson ePerson = (EPerson)ePersonService.find(c, uuid);
            if (ePerson != null) {
                try {
                    ePersonService.delete(c, (DSpaceObject)ePerson);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }
}

