/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.processor.BitstreamEventProcessor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BitstreamEventProcessorIT
extends AbstractIntegrationTestWithDatabase {
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private String encodedUrl;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.configurationService.setProperty("irus.statistics.tracker.enabled", (Object)true);
        String dspaceUrl = this.configurationService.getProperty("dspace.server.url");
        try {
            this.encodedUrl = URLEncoder.encode(dspaceUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Error occurred in setup()", e);
        }
    }

    @Test
    public void testAddObectSpecificData() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bitstream = BitstreamBuilder.createBitstream(this.context, item, (InputStream)new FileInputStream(f)).build();
        this.context.restoreAuthSystemState();
        BitstreamEventProcessor bitstreamEventProcessor = new BitstreamEventProcessor(this.context, request, bitstream);
        String result = bitstreamEventProcessor.addObjectSpecificData("existing-string", bitstream);
        MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)("existing-string&svc_dat=" + this.encodedUrl + "%2Fapi%2Fcore%2Fbitstreams%2F" + bitstream.getID() + "%2Fcontent&rft_dat=Request")));
    }
}

