/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.util.Set;
import org.dspace.statistics.util.IPTable;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class IPTableTest {
    private static final String LOCALHOST = "127.0.0.1";

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAdd() throws Exception {
        IPTable instance = new IPTable();
        instance.add(LOCALHOST);
        instance.add("192.168.1");
        Set ipSet = instance.toSet();
        Assert.assertEquals((long)2L, (long)ipSet.size());
        Assert.assertTrue((boolean)ipSet.contains(LOCALHOST));
        Assert.assertTrue((boolean)ipSet.contains("192.168.1"));
    }

    @Test
    public void testAddSameIPTwice() throws Exception {
        IPTable instance = new IPTable();
        instance.add(LOCALHOST);
        instance.add(LOCALHOST);
        Assert.assertEquals((long)1L, (long)instance.toSet().size());
        instance = new IPTable();
        instance.add("192.168.1");
        instance.add("192.168.1.1");
        Set ipSet = instance.toSet();
        Assert.assertEquals((long)1L, (long)ipSet.size());
        Assert.assertTrue((boolean)ipSet.contains("192.168.1"));
        instance = new IPTable();
        instance.add("192.168.1.1");
        instance.add("192.168.1");
        ipSet = instance.toSet();
        Assert.assertEquals((long)1L, (long)ipSet.size());
        Assert.assertTrue((boolean)ipSet.contains("192.168.1"));
    }

    @Test
    public void testContains() throws Exception {
        IPTable instance = new IPTable();
        instance.add(LOCALHOST);
        boolean contains = instance.contains(LOCALHOST);
        Assert.assertTrue((String)"Address that was add()ed should match", (boolean)contains);
        contains = instance.contains("192.168.1.1");
        Assert.assertFalse((String)"Address that was not add()ed should not match", (boolean)contains);
        contains = instance.contains("fec0:0:0:1::2");
        Assert.assertFalse((String)"IPv6 address should not match anything.", (boolean)contains);
        instance.add("192.168.1");
        contains = instance.contains("192.168.1.1");
        Assert.assertTrue((String)"IP within an add()ed range should match", (boolean)contains);
    }

    @Test
    public void testisEmpty() throws Exception {
        IPTable instance = new IPTable();
        Assert.assertTrue((boolean)instance.isEmpty());
        instance.add(LOCALHOST);
        Assert.assertFalse((boolean)instance.isEmpty());
    }

    @Test(expected=IPTable.IPFormatException.class)
    public void testContainsBadFormat() throws Exception {
        IPTable instance = new IPTable();
        instance.add(LOCALHOST);
        boolean contains = instance.contains("axolotl");
        Assert.assertFalse((String)"Nonsense string should raise an exception.", (boolean)contains);
    }

    @Ignore
    @Test
    public void testToSet() {
    }
}

