/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.spring.ConfigurationPropertySource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;

public class DSpaceConfigurationInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LogManager.getLogger();

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        Configuration configuration = configurationService.getConfiguration();
        ConfigurationPropertySource apacheCommonsConfigPropertySource = new ConfigurationPropertySource(configuration.getClass().getName(), configuration);
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)apacheCommonsConfigPropertySource);
    }
}

