/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.io.File;
import javax.naming.InitialContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.kernel.DSpaceKernel;
import org.dspace.kernel.DSpaceKernelManager;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.servicemanager.DSpaceKernelInit;
import org.dspace.servicemanager.config.DSpaceConfigurationService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;

public class DSpaceKernelInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LogManager.getLogger();
    private transient DSpaceKernel dspaceKernel;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.dspaceKernel = DSpaceKernelManager.getDefaultKernel();
        if (this.dspaceKernel == null) {
            DSpaceKernelImpl kernelImpl = null;
            try {
                kernelImpl = DSpaceKernelInit.getKernel(null);
                if (!kernelImpl.isRunning()) {
                    kernelImpl.start(this.getDSpaceHome(applicationContext.getEnvironment()));
                }
                this.dspaceKernel = kernelImpl;
            }
            catch (Exception e) {
                try {
                    if (kernelImpl != null) {
                        kernelImpl.destroy();
                    }
                    this.dspaceKernel = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String message = "Failure during ServletContext initialisation: " + e.getMessage();
                log.error("Failure during ServletContext initialisation: ", (Throwable)e);
                throw new RuntimeException(message, e);
            }
        }
        if (applicationContext.getParent() == null) {
            applicationContext.setParent((ApplicationContext)this.dspaceKernel.getServiceManager().getApplicationContext());
            applicationContext.addApplicationListener((ApplicationListener)new DSpaceKernelDestroyer(this.dspaceKernel));
        }
    }

    private String getDSpaceHome(ConfigurableEnvironment environment) {
        File test;
        String providedHome = environment.getProperty("dspace.dir");
        String dspaceHome = null;
        try {
            InitialContext ctx = new InitialContext();
            dspaceHome = (String)ctx.lookup("java:/comp/env/dspace.dir");
        }
        catch (Exception ctx) {
            // empty catch block
        }
        if (dspaceHome == null && StringUtils.isNotBlank((CharSequence)providedHome) && !providedHome.equals("${dspace.dir}") && (test = new File(providedHome)).exists() && new File(test, DSpaceConfigurationService.DSPACE_CONFIG_PATH).exists()) {
            dspaceHome = providedHome;
        }
        return dspaceHome;
    }

    private class DSpaceKernelDestroyer
    implements ApplicationListener<ContextClosedEvent> {
        private DSpaceKernel kernel;

        public DSpaceKernelDestroyer(DSpaceKernel kernel) {
            this.kernel = kernel;
        }

        public void onApplicationEvent(ContextClosedEvent event) {
            if (this.kernel != null) {
                this.kernel.destroy();
                this.kernel = null;
            }
        }
    }
}

