/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.dspace.authority.AuthorityValue;
import org.dspace.authority.SolrAuthorityInterface;
import org.dspace.authority.orcid.Orcidv3AuthorityValue;
import org.dspace.external.OrcidRestConnector;
import org.dspace.external.provider.orcid.xml.XMLtoBio;
import org.json.JSONObject;
import org.orcid.jaxb.model.v3.release.common.OrcidIdentifier;
import org.orcid.jaxb.model.v3.release.record.Person;
import org.orcid.jaxb.model.v3.release.search.Result;

public class Orcidv3SolrAuthorityImpl
implements SolrAuthorityInterface {
    private static Logger log = Logger.getLogger(Orcidv3SolrAuthorityImpl.class);
    private OrcidRestConnector orcidRestConnector;
    private String OAUTHUrl;
    private String clientId;
    private String clientSecret;
    private String accessToken;

    public void setOAUTHUrl(String oAUTHUrl) {
        this.OAUTHUrl = oAUTHUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void init() {
        if (StringUtils.isBlank((String)this.accessToken) && StringUtils.isNotBlank((String)this.clientSecret) && StringUtils.isNotBlank((String)this.clientId) && StringUtils.isNotBlank((String)this.OAUTHUrl)) {
            String authenticationParameters = "?client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&scope=/read-public&grant_type=client_credentials";
            try {
                HttpPost httpPost = new HttpPost(this.OAUTHUrl + authenticationParameters);
                httpPost.addHeader("Accept", "application/json");
                httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpResponse getResponse = httpClient.execute((HttpUriRequest)httpPost);
                JSONObject responseObject = null;
                try (InputStream is = getResponse.getEntity().getContent();
                     BufferedReader streamReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
                    String inputStr;
                    while ((inputStr = streamReader.readLine()) != null && responseObject == null) {
                        if (!inputStr.startsWith("{") || !inputStr.endsWith("}") || !inputStr.contains("access_token")) continue;
                        try {
                            responseObject = new JSONObject(inputStr);
                        }
                        catch (Exception e) {
                            responseObject = null;
                        }
                    }
                }
                if (responseObject != null && responseObject.has("access_token")) {
                    this.accessToken = (String)responseObject.get("access_token");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error during initialization of the Orcid connector", e);
            }
        }
    }

    public void setOrcidRestConnector(OrcidRestConnector orcidRestConnector) {
        this.orcidRestConnector = orcidRestConnector;
    }

    @Override
    public List<AuthorityValue> queryAuthorities(String text, int max) {
        this.init();
        List<Person> bios = this.queryBio(text, max);
        ArrayList<AuthorityValue> result = new ArrayList<AuthorityValue>();
        for (Person person : bios) {
            Orcidv3AuthorityValue orcidAuthorityValue = Orcidv3AuthorityValue.create(person);
            if (orcidAuthorityValue == null) continue;
            result.add(orcidAuthorityValue);
        }
        return result;
    }

    @Override
    public AuthorityValue queryAuthorityID(String id) {
        this.init();
        Person person = this.getBio(id);
        Orcidv3AuthorityValue valueFromPerson = Orcidv3AuthorityValue.create(person);
        return valueFromPerson;
    }

    public Person getBio(String id) {
        log.debug((Object)("getBio called with ID=" + id));
        if (!this.isValid(id)) {
            return null;
        }
        this.init();
        InputStream bioDocument = this.orcidRestConnector.get(id + (id.endsWith("/person") ? "" : "/person"), this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        Person person = converter.convertSinglePerson(bioDocument);
        return person;
    }

    public List<Person> queryBio(String text, int start, int rows) {
        this.init();
        if (rows > 100) {
            throw new IllegalArgumentException("The maximum number of results to retrieve cannot exceed 100.");
        }
        String searchPath = "search?q=" + URLEncoder.encode(text) + "&start=" + start + "&rows=" + rows;
        log.debug((Object)("queryBio searchPath=" + searchPath + " accessToken=" + this.accessToken));
        InputStream bioDocument = this.orcidRestConnector.get(searchPath, this.accessToken);
        XMLtoBio converter = new XMLtoBio();
        Object results = converter.convert(bioDocument);
        LinkedList<Person> bios = new LinkedList<Person>();
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            OrcidIdentifier orcidIdentifier = result.getOrcidIdentifier();
            if (orcidIdentifier == null) continue;
            log.debug((Object)("Found OrcidId=" + orcidIdentifier.toString()));
            String orcid = orcidIdentifier.getPath();
            Person bio = this.getBio(orcid);
            if (bio == null) continue;
            bios.add(bio);
        }
        try {
            bioDocument.close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return bios;
    }

    public List<Person> queryBio(String text, int max) {
        return this.queryBio(text, 0, max);
    }

    private boolean isValid(String text) {
        return StringUtils.isNotBlank((String)text) && text.matches("\\d{4}-\\d{4}-\\d{4}-(\\d{3}X|\\d{4})");
    }
}

