/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.dspace.content.MetadataSchemaEnum;

public class MetadataFieldName {
    public final String SCHEMA;
    public final String ELEMENT;
    public final String QUALIFIER;

    public MetadataFieldName(@Nonnull String schema, @Nonnull String element, String qualifier) {
        if (null == schema) {
            throw new NullPointerException("Schema must not be null.");
        }
        if (null == element) {
            throw new NullPointerException("Element must not be null.");
        }
        this.SCHEMA = schema;
        this.ELEMENT = element;
        this.QUALIFIER = qualifier;
    }

    public MetadataFieldName(@Nonnull String schema, @Nonnull String element) {
        if (null == schema) {
            throw new NullPointerException("Schema must not be null.");
        }
        if (null == element) {
            throw new NullPointerException("Element must not be null.");
        }
        this.SCHEMA = schema;
        this.ELEMENT = element;
        this.QUALIFIER = null;
    }

    public MetadataFieldName(@Nonnull MetadataSchemaEnum schema, @Nonnull String element, String qualifier) {
        if (null == schema) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        if (null == element) {
            throw new IllegalArgumentException("Element must not be null.");
        }
        this.SCHEMA = schema.getName();
        this.ELEMENT = element;
        this.QUALIFIER = qualifier;
    }

    public MetadataFieldName(@Nonnull MetadataSchemaEnum schema, @Nonnull String element) {
        if (null == schema) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        if (null == element) {
            throw new IllegalArgumentException("Element must not be null.");
        }
        this.SCHEMA = schema.getName();
        this.ELEMENT = element;
        this.QUALIFIER = null;
    }

    public MetadataFieldName(@Nonnull String name) {
        String[] elements = MetadataFieldName.parse(name);
        this.SCHEMA = elements[0];
        this.ELEMENT = elements[1];
        this.QUALIFIER = elements[2];
    }

    public static String[] parse(@Nonnull String name) {
        if (null == name) {
            throw new NullPointerException("Name is null");
        }
        String[] elements = name.split("\\.", 3);
        if (elements.length < 2) {
            throw new IllegalArgumentException("Not enough elements:  " + name);
        }
        return Arrays.copyOf(elements, 3);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(this.SCHEMA).append('.').append(this.ELEMENT);
        if (null != this.QUALIFIER) {
            buffer.append('.').append(this.QUALIFIER);
        }
        return buffer.toString();
    }
}

