/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DSpaceCommandLineParameter {
    private String name;
    private String value;
    public static String SEPARATOR = "|||";

    public DSpaceCommandLineParameter(String key, String value) {
        this.name = key;
        this.value = StringUtils.isBlank((CharSequence)value) ? null : value;
    }

    protected DSpaceCommandLineParameter(String parameter) {
        this(StringUtils.substringBefore((String)parameter, (String)" "), StringUtils.substringAfter((String)parameter, (String)" "));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String key) {
        this.name = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        Object stringToReturn = "";
        stringToReturn = (String)stringToReturn + this.getName();
        if (StringUtils.isNotBlank((CharSequence)this.getValue())) {
            stringToReturn = (String)stringToReturn + " ";
            stringToReturn = (String)stringToReturn + this.getValue();
        }
        return stringToReturn;
    }

    public static String concatenate(List<DSpaceCommandLineParameter> parameterList) {
        if (parameterList.isEmpty()) {
            return null;
        }
        return parameterList.stream().map(parameter -> parameter.toString()).collect(Collectors.joining(SEPARATOR));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != DSpaceCommandLineParameter.class) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getName(), (CharSequence)((DSpaceCommandLineParameter)other).getName()) && StringUtils.equals((CharSequence)this.getValue(), (CharSequence)((DSpaceCommandLineParameter)other).getValue());
    }

    public int hashCode() {
        return new HashCodeBuilder(5, 17).append((Object)this.getName()).append((Object)this.getValue()).toHashCode();
    }
}

