/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.storage.rdbms.PostgresUtils;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;

public class PostgreSQLCryptoChecker
implements Callback {
    private Logger log = LogManager.getLogger(PostgreSQLCryptoChecker.class);

    public void checkPgCrypto(Connection connection) {
        String dbType;
        try {
            dbType = DatabaseUtils.getDbType(connection);
        }
        catch (SQLException se) {
            throw new FlywayException("Unable to determine database type.", (Throwable)se);
        }
        if (dbType != null && dbType.equals("postgres") && !PostgresUtils.isPgcryptoUpToDate()) {
            throw new FlywayException("This PostgreSQL Database is INCOMPATIBLE with DSpace. The upgrade will NOT proceed. A supported version (>=" + PostgresUtils.PGCRYPTO_VERSION + ") of the 'pgcrypto' extension must be installed! Please run 'dspace database info' for additional info/tips.");
        }
    }

    public void removePgCrypto(Connection connection) {
        block8: {
            try {
                String schema;
                String dbType = DatabaseUtils.getDbType(connection);
                if (dbType == null || !dbType.equals("postgres") || !PostgresUtils.isPgcryptoInSchema(schema = DatabaseUtils.getSchemaName(connection))) break block8;
                try (Statement statement = connection.createStatement();){
                    statement.execute("DROP EXTENSION pgcrypto CASCADE");
                }
            }
            catch (SQLException e) {
                throw new FlywayException("Failed to check for and/or remove 'pgcrypto' extension", (Throwable)e);
            }
        }
    }

    public boolean supports(Event event, Context context) {
        return event.equals((Object)Event.BEFORE_BASELINE) || event.equals((Object)Event.BEFORE_MIGRATE) || event.equals((Object)Event.BEFORE_CLEAN);
    }

    public boolean canHandleInTransaction(Event event, Context context) {
        return true;
    }

    public void handle(Event event, Context context) {
        if (event.equals((Object)Event.BEFORE_BASELINE) || event.equals((Object)Event.BEFORE_MIGRATE)) {
            this.checkPgCrypto(context.getConnection());
        } else if (event.equals((Object)Event.BEFORE_CLEAN)) {
            this.removePgCrypto(context.getConnection());
        }
    }
}

