/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class MetadataFieldBuilder
extends AbstractBuilder<MetadataField, MetadataFieldService> {
    private static final Logger log = LogManager.getLogger(MetadataFieldBuilder.class);
    private MetadataField metadataField;

    protected MetadataFieldBuilder(Context context) {
        super(context);
    }

    @Override
    protected MetadataFieldService getService() {
        return metadataFieldService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.metadataField = (MetadataField)c.reloadEntity((ReloadableEntity)this.metadataField);
            if (this.metadataField != null) {
                this.delete(c, this.metadataField);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, MetadataField dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, dso);
        }
    }

    @Override
    public MetadataField build() {
        try {
            metadataFieldService.update(this.context, this.metadataField);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (IOException | SQLException | AuthorizeException | NonUniqueMetadataException | SearchServiceException e) {
            log.error("Failed to complete MetadataField", e);
        }
        return this.metadataField;
    }

    public void delete(MetadataField dso) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            MetadataField attachedDso = (MetadataField)c.reloadEntity((ReloadableEntity)dso);
            if (attachedDso != null) {
                this.getService().delete(c, attachedDso);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static void deleteMetadataField(Integer id) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            MetadataField metadataField = metadataFieldService.find(c, id.intValue());
            if (metadataField != null) {
                try {
                    metadataFieldService.delete(c, metadataField);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }

    public static MetadataFieldBuilder createMetadataField(Context context, String element, String qualifier, String scopeNote) throws SQLException, AuthorizeException {
        MetadataFieldBuilder metadataFieldBuilder = new MetadataFieldBuilder(context);
        return metadataFieldBuilder.create(context, element, qualifier, scopeNote);
    }

    public static MetadataFieldBuilder createMetadataField(Context context, MetadataSchema schema, String element, String qualifier, String scopeNote) throws SQLException, AuthorizeException {
        MetadataFieldBuilder metadataFieldBuilder = new MetadataFieldBuilder(context);
        return metadataFieldBuilder.create(context, schema, element, qualifier, scopeNote);
    }

    private MetadataFieldBuilder create(Context context, String element, String qualifier, String scopeNote) throws SQLException, AuthorizeException {
        this.create(context, metadataSchemaService.find(context, "dc"), element, qualifier, scopeNote);
        return this;
    }

    private MetadataFieldBuilder create(Context context, MetadataSchema schema, String element, String qualifier, String scopeNote) throws SQLException, AuthorizeException {
        this.context = context;
        try {
            this.metadataField = metadataFieldService.create(context, schema, element, qualifier, scopeNote);
        }
        catch (NonUniqueMetadataException e) {
            log.error("Failed to create MetadataField", (Throwable)e);
        }
        return this;
    }
}

