/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Site;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.eperson.Group;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SiteTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(SiteTest.class);
    private Site s;
    private final SiteService siteService = ContentServiceFactory.getInstance().getSiteService();
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.s = this.siteService.findSite(this.context);
            this.context.restoreAuthSystemState();
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.s = null;
        super.destroy();
    }

    @Test
    public void testGetType() {
        MatcherAssert.assertThat((String)"testGetType 0", (Object)this.s.getType(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.s.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testGetHandle() {
        MatcherAssert.assertThat((String)"testGetHandle 0", (Object)this.s.getHandle(), (Matcher)CoreMatchers.equalTo((Object)(this.configurationService.getProperty("handle.prefix") + "/0")));
    }

    @Test
    public void testGetSiteHandle() {
        MatcherAssert.assertThat((String)"testGetSiteHandle 0", (Object)this.s.getHandle(), (Matcher)CoreMatchers.equalTo((Object)(this.configurationService.getProperty("handle.prefix") + "/0")));
    }

    @Test
    public void testSiteFind() throws Exception {
        Site found = this.siteService.findSite(this.context);
        MatcherAssert.assertThat((String)"testSiteFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSiteFind 1", (Object)found, (Matcher)CoreMatchers.equalTo((Object)this.s));
    }

    @Test
    public void testGetName() {
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.s.getName(), (Matcher)CoreMatchers.equalTo((Object)this.configurationService.getProperty("dspace.name")));
        MatcherAssert.assertThat((String)"testGetName 1", (Object)this.siteService.getName((DSpaceObject)this.s), (Matcher)CoreMatchers.equalTo((Object)this.configurationService.getProperty("dspace.name")));
    }

    @Test
    public void testGetURL() {
        MatcherAssert.assertThat((String)"testGetURL 0", (Object)this.s.getURL(), (Matcher)CoreMatchers.equalTo((Object)this.configurationService.getProperty("dspace.ui.url")));
    }

    @Test
    public void testAnonymousReadRights() throws Exception {
        List groupList = this.authorizeService.getAuthorizedGroups(this.context, (DSpaceObject)this.s, 0);
        boolean foundAnonInList = false;
        for (Group group : groupList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)group.getName(), (CharSequence)"Anonymous")) continue;
            foundAnonInList = true;
        }
        Assert.assertTrue((boolean)foundAnonInList);
    }
}

