/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.CollectionRoleService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class EPersonInWorkflowIT
extends AbstractIntegrationTestWithDatabase {
    private final String REVIEW_STEP = "reviewstep";
    private final String CLAIM_ACTION = "claimaction";
    private final String REVIEW_ACTION = "reviewaction";
    private final String REVIEW_ROLE = "reviewer";
    private final String EDIT_STEP = "editstep";
    private final String EDIT_ACTION = "editaction";
    private final String FINAL_EDIT_ROLE = "finaleditor";
    private final String FINAL_EDIT_STEP = "finaleditstep";
    private final String FINAL_EDIT_ACTION = "finaleditaction";
    private final String EDIT_ROLE = "editor";
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    protected CollectionRoleService collectionRoleService = XmlWorkflowServiceFactory.getInstance().getCollectionRoleService();
    private EPerson workflowUserA;
    private EPerson workflowUserB;
    private EPerson workflowUserC;
    private EPerson workflowUserD;
    private static final Logger log = LogManager.getLogger(EPersonInWorkflowIT.class);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        this.workflowUserA = EPersonBuilder.createEPerson(this.context).withEmail("workflowUserA@example.org").build();
        this.workflowUserB = EPersonBuilder.createEPerson(this.context).withEmail("workflowUserB@example.org").build();
        this.workflowUserC = EPersonBuilder.createEPerson(this.context).withEmail("workflowUserC@example.org").build();
        this.workflowUserD = EPersonBuilder.createEPerson(this.context).withEmail("workflowUserD@example.org").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup1() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", false);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "finaleditor", true);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", true);
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", false);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", true);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "finaleditor", true);
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup3() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserC, false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserC, collection, "editor", true);
        this.assertDeletionOfEperson(this.workflowUserC, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup4() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", true);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "finaleditor", false);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "finaleditor", true);
        this.assertDeletionOfEperson(this.workflowUserB, true);
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup5() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collectionA = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        Collection collectionB = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collectionA).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collectionA);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collectionA, "finaleditor", true);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collectionB, "reviewer", true);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collectionA, "reviewer", false);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collectionA, "reviewer", true);
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup6() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserA, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenOnlyUserInGroup7() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", false);
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "finaleditor", true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.assertRemovalOfEpersonFromWorkflowGroup(this.workflowUserB, collection, "reviewer", true);
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser1() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "finaleditor");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "reviewer");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "reviewer");
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "finaleditor");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser3() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserC, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "editor");
        this.assertDeletionOfEperson(this.workflowUserC, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser4() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "reviewer");
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "finaleditor");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser5() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserC, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "editor");
        this.assertDeletionOfEperson(this.workflowUserC, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserAfterReplacingUser6() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB).withWorkflowGroup(2, this.workflowUserC).withWorkflowGroup(3, this.workflowUserB).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.assertDeletionOfEperson(this.workflowUserB, false);
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "reviewer");
        this.addUserToWorkflowGroup(this.workflowUserD, collection, "finaleditor");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser1() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser2() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser3() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.assertDeletionOfEperson(this.workflowUserC, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser4() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser5() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserC, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    @Test
    public void testDeleteUserWhenMultipleUser6() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community parent = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, parent).withWorkflowGroup(1, this.workflowUserB, this.workflowUserD).withWorkflowGroup(2, this.workflowUserC, this.workflowUserD).withWorkflowGroup(3, this.workflowUserB, this.workflowUserD).build();
        WorkspaceItem wsi = WorkspaceItemBuilder.createWorkspaceItem(this.context, collection).withSubmitter(this.workflowUserA).withTitle("Test item full workflow").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        XmlWorkflowItem workflowItem = (XmlWorkflowItem)this.xmlWorkflowService.startWithoutNotify(this.context, wsi);
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "reviewstep", "reviewaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserC, workflow, workflowItem, "editstep", "editaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserB, workflow, workflowItem, "finaleditstep", "claimaction");
        this.assertDeletionOfEperson(this.workflowUserB, true);
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "claimaction");
        this.executeWorkflowAction((HttpServletRequest)httpServletRequest, this.workflowUserD, workflow, workflowItem, "finaleditstep", "finaleditaction");
        Assert.assertTrue((boolean)workflowItem.getItem().isArchived());
    }

    private void addUserToWorkflowGroup(EPerson ePerson, Collection collection, String roleName) throws SQLException {
        List roles = this.collectionRoleService.findByCollection(this.context, collection);
        for (CollectionRole role : roles) {
            if (!StringUtils.equals((CharSequence)role.getRoleId(), (CharSequence)roleName)) continue;
            Group group = role.getGroup();
            this.groupService.addMember(this.context, group, ePerson);
        }
    }

    private void executeWorkflowAction(HttpServletRequest httpServletRequest, EPerson user, Workflow workflow, XmlWorkflowItem workflowItem, String stepId, String actionId) throws Exception {
        this.context.setCurrentUser(user);
        this.xmlWorkflowService.doState(this.context, user, httpServletRequest, workflowItem.getID().intValue(), workflow, workflow.getStep(stepId).getActionConfig(actionId));
        this.context.setCurrentUser(null);
    }

    private void assertRemovalOfEpersonFromWorkflowGroup(EPerson ePerson, Collection collection, String roleName, boolean shouldSucceed) {
        boolean deleteSuccess = false;
        boolean deleteError = false;
        try {
            List roles = this.collectionRoleService.findByCollection(this.context, collection);
            for (CollectionRole role : roles) {
                if (!StringUtils.equals((CharSequence)role.getRoleId(), (CharSequence)roleName)) continue;
                Group group = role.getGroup();
                this.groupService.removeMember(this.context, group, ePerson);
                deleteSuccess = true;
            }
        }
        catch (Exception ex) {
            if (ex instanceof IllegalStateException) {
                deleteSuccess = false;
                deleteError = true;
            }
            deleteSuccess = false;
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", (Throwable)ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        if (shouldSucceed) {
            Assert.assertTrue((boolean)deleteSuccess);
            Assert.assertFalse((boolean)deleteError);
        } else {
            Assert.assertTrue((boolean)deleteError);
            Assert.assertFalse((boolean)deleteSuccess);
        }
    }

    private void assertDeletionOfEperson(EPerson ePerson, boolean shouldSucceed) throws SQLException {
        boolean deleteSuccess;
        boolean deleteError = false;
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ePerson);
            deleteSuccess = true;
        }
        catch (Exception ex) {
            if (ex instanceof IllegalStateException) {
                deleteSuccess = false;
                deleteError = true;
            }
            deleteSuccess = false;
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", (Throwable)ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        EPerson ePersonCheck = (EPerson)this.ePersonService.find(this.context, ePerson.getID());
        if (shouldSucceed) {
            Assert.assertTrue((boolean)deleteSuccess);
            Assert.assertFalse((boolean)deleteError);
            Assert.assertNull((Object)ePersonCheck);
        } else {
            Assert.assertTrue((boolean)deleteError);
            Assert.assertFalse((boolean)deleteSuccess);
            Assert.assertNotNull((Object)ePerson);
        }
    }
}

