/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.service;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.core.Context;
import org.dspace.statistics.export.OpenURLTracker;
import org.dspace.statistics.export.service.FailedOpenURLTrackerService;
import org.dspace.statistics.export.service.OpenUrlServiceImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class OpenUrlServiceImplTest {
    @InjectMocks
    @Spy
    private OpenUrlServiceImpl openUrlService;
    @Mock
    private FailedOpenURLTrackerService failedOpenURLTrackerService;

    @Test
    public void testProcessUrl() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ((OpenUrlServiceImpl)Mockito.doReturn((Object)200).when((Object)this.openUrlService)).getResponseCodeFromUrl(ArgumentMatchers.anyString());
        this.openUrlService.processUrl(context, "test-url");
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)0))).logfailed(context, "test-url");
    }

    @Test
    public void testProcessUrlOnFail() throws IOException, SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ((OpenUrlServiceImpl)Mockito.doReturn((Object)500).when((Object)this.openUrlService)).getResponseCodeFromUrl(ArgumentMatchers.anyString());
        ((OpenUrlServiceImpl)Mockito.doNothing().when((Object)this.openUrlService)).logfailed((Context)ArgumentMatchers.any(Context.class), ArgumentMatchers.anyString());
        this.openUrlService.processUrl(context, "test-url");
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)1))).logfailed(context, "test-url");
    }

    @Test
    public void testReprocessFailedQueue() throws SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        ArrayList<OpenURLTracker> trackers = new ArrayList<OpenURLTracker>();
        OpenURLTracker tracker1 = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        OpenURLTracker tracker2 = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        OpenURLTracker tracker3 = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        trackers.add(tracker1);
        trackers.add(tracker2);
        trackers.add(tracker3);
        Mockito.when((Object)this.failedOpenURLTrackerService.findAll((Context)ArgumentMatchers.any(Context.class))).thenReturn(trackers);
        ((OpenUrlServiceImpl)Mockito.doNothing().when((Object)this.openUrlService)).tryReprocessFailed((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.any(OpenURLTracker.class));
        this.openUrlService.reprocessFailedQueue(context);
        ((OpenUrlServiceImpl)Mockito.verify((Object)this.openUrlService, (VerificationMode)Mockito.times((int)3))).tryReprocessFailed((Context)ArgumentMatchers.any(Context.class), (OpenURLTracker)ArgumentMatchers.any(OpenURLTracker.class));
    }

    @Test
    public void testLogfailed() throws SQLException {
        Context context = (Context)Mockito.mock(Context.class);
        OpenURLTracker tracker1 = (OpenURLTracker)Mockito.mock(OpenURLTracker.class);
        ((OpenURLTracker)Mockito.doCallRealMethod().when((Object)tracker1)).setUrl(ArgumentMatchers.anyString());
        Mockito.when((Object)tracker1.getUrl()).thenCallRealMethod();
        Mockito.when((Object)this.failedOpenURLTrackerService.create((Context)ArgumentMatchers.any(Context.class))).thenReturn((Object)tracker1);
        String failedUrl = "failed-url";
        this.openUrlService.logfailed(context, failedUrl);
        MatcherAssert.assertThat((Object)tracker1.getUrl(), (Matcher)CoreMatchers.is((Object)failedUrl));
    }
}

