/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.services.factory.DSpaceServicesFactory;

public class ItemCountDAOSolr
implements ItemCountDAO {
    private static Logger log = LogManager.getLogger(ItemCountDAOSolr.class);
    private Context context;
    private Map<String, Integer> communitiesCount = null;
    private Map<String, Integer> collectionsCount = null;
    SearchService searcher = (SearchService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);

    @Override
    public void setContext(Context context) throws ItemCountException {
        this.context = context;
    }

    @Override
    public int getCount(DSpaceObject dso) throws ItemCountException {
        Integer val;
        this.loadCount();
        if (dso instanceof Collection) {
            val = this.collectionsCount.get(String.valueOf(((Collection)dso).getID()));
        } else if (dso instanceof Community) {
            val = this.communitiesCount.get(String.valueOf(((Community)dso).getID()));
        } else {
            throw new ItemCountException("We can only count items in Communities or Collections");
        }
        if (val != null) {
            return val;
        }
        return 0;
    }

    private void loadCount() throws ItemCountException {
        if (this.communitiesCount != null || this.collectionsCount != null) {
            return;
        }
        this.communitiesCount = new HashMap<String, Integer>();
        this.collectionsCount = new HashMap<String, Integer>();
        DiscoverQuery query = new DiscoverQuery();
        query.setFacetMinCount(1);
        query.addFacetField(new DiscoverFacetField("location.comm", "standard", -1, DiscoveryConfigurationParameters.SORT.COUNT));
        query.addFacetField(new DiscoverFacetField("location.coll", "standard", -1, DiscoveryConfigurationParameters.SORT.COUNT));
        query.addFilterQueries("search.resourcetype:" + IndexableItem.TYPE);
        query.addFilterQueries("NOT(discoverable:false)");
        query.setMaxResults(0);
        DiscoverResult sResponse = null;
        try {
            sResponse = this.searcher.search(this.context, query);
            List<DiscoverResult.FacetResult> commCount = sResponse.getFacetResult("location.comm");
            List<DiscoverResult.FacetResult> collCount = sResponse.getFacetResult("location.coll");
            for (DiscoverResult.FacetResult c : commCount) {
                this.communitiesCount.put(c.getAsFilterQuery(), (int)c.getCount());
            }
            for (DiscoverResult.FacetResult c : collCount) {
                this.collectionsCount.put(c.getAsFilterQuery(), (int)c.getCount());
            }
        }
        catch (SearchServiceException e) {
            log.error("caught exception: ", (Throwable)e);
            throw new ItemCountException(e);
        }
    }
}

