/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.dspace.content.MetadataSchemaEnum;

public class MetadataFieldName {
    public final String schema;
    public final String element;
    public final String qualifier;

    public MetadataFieldName(@Nonnull String schema, @Nonnull String element, String qualifier) {
        if (null == schema) {
            throw new NullPointerException("Schema must not be null.");
        }
        if (null == element) {
            throw new NullPointerException("Element must not be null.");
        }
        this.schema = schema;
        this.element = element;
        this.qualifier = qualifier;
    }

    public MetadataFieldName(@Nonnull String schema, @Nonnull String element) {
        if (null == schema) {
            throw new NullPointerException("Schema must not be null.");
        }
        if (null == element) {
            throw new NullPointerException("Element must not be null.");
        }
        this.schema = schema;
        this.element = element;
        this.qualifier = null;
    }

    public MetadataFieldName(@Nonnull MetadataSchemaEnum schema, @Nonnull String element, String qualifier) {
        if (null == schema) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        if (null == element) {
            throw new IllegalArgumentException("Element must not be null.");
        }
        this.schema = schema.getName();
        this.element = element;
        this.qualifier = qualifier;
    }

    public MetadataFieldName(@Nonnull MetadataSchemaEnum schema, @Nonnull String element) {
        if (null == schema) {
            throw new IllegalArgumentException("Schema must not be null.");
        }
        if (null == element) {
            throw new IllegalArgumentException("Element must not be null.");
        }
        this.schema = schema.getName();
        this.element = element;
        this.qualifier = null;
    }

    public MetadataFieldName(@Nonnull String name) {
        String[] elements = MetadataFieldName.parse(name);
        this.schema = elements[0];
        this.element = elements[1];
        this.qualifier = elements[2];
    }

    public static String[] parse(@Nonnull String name) {
        if (null == name) {
            throw new NullPointerException("Name is null");
        }
        String[] elements = name.split("\\.", 3);
        if (elements.length < 2) {
            throw new IllegalArgumentException("Not enough elements:  " + name);
        }
        return Arrays.copyOf(elements, 3);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(this.schema).append('.').append(this.element);
        if (null != this.qualifier) {
            buffer.append('.').append(this.qualifier);
        }
        return buffer.toString();
    }
}

