/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic.condition;

import java.util.List;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.AbstractCondition;
import org.dspace.core.Context;

public class BitstreamCountCondition
extends AbstractCondition {
    @Override
    public boolean getResult(Context context, Item item) throws LogicalStatementException {
        super.getResult(context, item);
        int min = -1;
        if (this.getParameters().get("min") != null) {
            min = Integer.parseInt((String)this.getParameters().get("min"));
        }
        int max = -1;
        if (this.getParameters().get("max") != null) {
            max = Integer.parseInt((String)this.getParameters().get("max"));
        }
        String bundleName = (String)this.getParameters().get("bundle");
        if (min < 0 && max < 0) {
            throw new LogicalStatementException("Either min or max parameter must be 0 or bigger.");
        }
        int count = 0;
        List<Bundle> bundles = bundleName != null ? item.getBundles(bundleName) : item.getBundles();
        for (Bundle bundle : bundles) {
            count += bundle.getBitstreams().size();
        }
        if (min < 0) {
            return count <= max;
        }
        if (max < 0) {
            return count >= min;
        }
        return count <= max && count >= min;
    }
}

