/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic.condition;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.AbstractCondition;
import org.dspace.core.Context;

public class MetadataValueMatchCondition
extends AbstractCondition {
    private static Logger log = Logger.getLogger(MetadataValueMatchCondition.class);

    @Override
    public boolean getResult(Context context, Item item) throws LogicalStatementException {
        String field = (String)this.getParameters().get("field");
        if (field == null) {
            return false;
        }
        String[] fieldParts = field.split("\\.");
        String schema = fieldParts.length > 0 ? fieldParts[0] : null;
        String element = fieldParts.length > 1 ? fieldParts[1] : null;
        String qualifier = fieldParts.length > 2 ? fieldParts[2] : null;
        List<MetadataValue> values = this.itemService.getMetadata(item, schema, element, qualifier, "*");
        for (MetadataValue value : values) {
            if (!(this.getParameters().get("pattern") instanceof String)) continue;
            String pattern = (String)this.getParameters().get("pattern");
            log.debug((Object)("logic for " + item.getHandle() + ": pattern passed is " + pattern + ", checking value " + value.getValue()));
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(value.getValue());
            if (!m.find()) continue;
            return true;
        }
        return false;
    }
}

