/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationService;
import org.dspace.kernel.ServiceManager;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowItem;

public class SearchUtils {
    public static final String AUTHORITY_SEPARATOR = "###";
    public static final String LAST_INDEXED_FIELD = "SolrIndexer.lastIndexed";
    public static final String RESOURCE_UNIQUE_ID = "search.uniqueid";
    public static final String RESOURCE_TYPE_FIELD = "search.resourcetype";
    public static final String RESOURCE_ID_FIELD = "search.resourceid";
    public static final String NAMED_RESOURCE_TYPE = "namedresourcetype";
    public static final String FILTER_SEPARATOR = "\n|||\n";
    private static SearchService searchService;

    private SearchUtils() {
    }

    public static SearchService getSearchService() {
        if (searchService == null) {
            ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
            searchService = (SearchService)manager.getServiceByName(SearchService.class.getName(), SearchService.class);
        }
        return searchService;
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration() {
        return SearchUtils.getDiscoveryConfiguration(null, null);
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(DSpaceObject dso) {
        return SearchUtils.getDiscoveryConfiguration(null, dso);
    }

    public static DiscoveryConfiguration getDiscoveryConfiguration(String prefix, DSpaceObject dso) {
        if (prefix != null) {
            return SearchUtils.getDiscoveryConfigurationByName((String)(dso != null ? prefix + "." + dso.getHandle() : prefix));
        }
        return SearchUtils.getDiscoveryConfigurationByName(dso != null ? dso.getHandle() : null);
    }

    public static DiscoveryConfiguration getDiscoveryConfigurationByName(String configurationName) {
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        return configurationService.getDiscoveryConfiguration(configurationName);
    }

    public static DiscoveryConfigurationService getConfigurationService() {
        ServiceManager manager = DSpaceServicesFactory.getInstance().getServiceManager();
        return (DiscoveryConfigurationService)manager.getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
    }

    public static List<String> getIgnoredMetadataFields(int type) {
        return SearchUtils.getConfigurationService().getToIgnoreMetadataFields().get(type);
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(Item item) throws SQLException {
        List<Collection> collections = item.getCollections();
        return SearchUtils.getAllDiscoveryConfigurations(null, collections, item);
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(WorkspaceItem witem) throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        collections.add(witem.getCollection());
        return SearchUtils.getAllDiscoveryConfigurations("workspace", collections, witem.getItem());
    }

    public static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(WorkflowItem witem) throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        collections.add(witem.getCollection());
        return SearchUtils.getAllDiscoveryConfigurations("workflow", collections, witem.getItem());
    }

    private static List<DiscoveryConfiguration> getAllDiscoveryConfigurations(String prefix, List<Collection> collections, Item item) throws SQLException {
        HashSet<DiscoveryConfiguration> result = new HashSet<DiscoveryConfiguration>();
        for (Collection collection : collections) {
            DiscoveryConfiguration configuration = SearchUtils.getDiscoveryConfiguration(prefix, collection);
            result.add(configuration);
        }
        DiscoveryConfigurationService configurationService = SearchUtils.getConfigurationService();
        result.addAll(configurationService.getIndexAlwaysConfigurations());
        SearchUtils.addConfigurationIfExists(result, prefix);
        return Arrays.asList(result.toArray(new DiscoveryConfiguration[result.size()]));
    }

    private static void addConfigurationIfExists(Set<DiscoveryConfiguration> result, String confName) {
        DiscoveryConfiguration configurationExtra = SearchUtils.getDiscoveryConfigurationByName(confName);
        result.add(configurationExtra);
    }
}

