/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import eu.openaire.jaxb.helper.FundingHelper;
import eu.openaire.jaxb.helper.ProjectHelper;
import eu.openaire.jaxb.model.Response;
import eu.openaire.jaxb.model.Result;
import eu.openaire.oaf.model.base.FunderType;
import eu.openaire.oaf.model.base.FundingTreeType;
import eu.openaire.oaf.model.base.FundingType;
import eu.openaire.oaf.model.base.Project;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.OpenAIRERestConnector;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class OpenAIREFundingDataProvider
extends AbstractExternalDataProvider {
    private static Logger log = LogManager.getLogger(OpenAIREFundingDataProvider.class);
    protected static final String PREFIX = "info:eu-repo/grantAgreement";
    protected static final int LIMIT_DEFAULT = 10;
    protected String sourceIdentifier;
    protected OpenAIRERestConnector connector;

    public void init() throws IOException {
    }

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        String decodedId = new String(Base64.getDecoder().decode(id));
        if (!OpenAIREFundingDataProvider.isValidProjectURI(decodedId)) {
            log.error("Invalid ID for OpenAIREFunding - " + id);
            return Optional.empty();
        }
        Response response = this.searchByProjectURI(decodedId);
        try {
            if (response.getHeader() != null && Integer.parseInt(response.getHeader().getTotal()) > 0) {
                Project project = ((Result)response.getResults().getResult().get(0)).getMetadata().getEntity().getProject();
                ExternalDataObject externalDataObject = new ExternalDataObjectBuilder(project).setId(OpenAIREFundingDataProvider.generateProjectURI(project)).setSource(this.sourceIdentifier).build();
                return Optional.of(externalDataObject);
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid Total from response - " + e.getMessage());
        }
        return Optional.empty();
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        String encodedQuery;
        int page;
        Response projectResponse;
        if (limit < 1) {
            limit = 10;
        }
        if ((projectResponse = this.connector.searchProjectByKeywords(page = start / limit + 1, limit, encodedQuery = OpenAIREFundingDataProvider.encodeValue(query))) == null || projectResponse.getResults() == null) {
            return Collections.emptyList();
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Result result : projectResponse.getResults().getResult()) {
            if (result.getMetadata() != null && result.getMetadata().getEntity() != null && result.getMetadata().getEntity().getProject() != null) {
                projects.add(result.getMetadata().getEntity().getProject());
                continue;
            }
            throw new IllegalStateException("No project found");
        }
        if (projects.size() > 0) {
            return projects.stream().map(project -> new ExternalDataObjectBuilder((Project)project).setId(OpenAIREFundingDataProvider.generateProjectURI(project)).setSource(this.sourceIdentifier).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String query) {
        String encodedQuery = OpenAIREFundingDataProvider.encodeValue(query);
        Response projectResponse = this.connector.searchProjectByKeywords(0, 0, encodedQuery);
        return Integer.parseInt(projectResponse.getHeader().getTotal());
    }

    @Autowired(required=true)
    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public OpenAIRERestConnector getConnector() {
        return this.connector;
    }

    @Autowired(required=true)
    public void setConnector(OpenAIRERestConnector connector) {
        this.connector = connector;
    }

    public Response searchByProjectURI(String projectURI) {
        String[] splittedURI = projectURI.replaceAll(PREFIX, "").split("/");
        return this.connector.searchProjectByIDAndFunder(splittedURI[3], splittedURI[1], 1, 1);
    }

    private static boolean isValidProjectURI(String projectURI) {
        return Pattern.matches("info:eu-repo/grantAgreement/.+/.+/.*", projectURI);
    }

    private static String generateProjectURI(Project project) {
        Optional optCode;
        ProjectHelper projectHelper = new ProjectHelper(project.getCodeOrTitleOrAcronym());
        String prefix = PREFIX;
        String funderShortName = "+";
        String fundingName = "+";
        String code = "+";
        String jurisdiction = "+";
        Optional fundingTree = projectHelper.getFundingTreeTypes().stream().findFirst();
        if (!fundingTree.isEmpty()) {
            FundingHelper fundingHelper;
            Optional funding;
            if (((FundingTreeType)fundingTree.get()).getFunder() != null) {
                if (((FundingTreeType)fundingTree.get()).getFunder().getShortname() != null) {
                    funderShortName = OpenAIREFundingDataProvider.encodeValue(((FundingTreeType)fundingTree.get()).getFunder().getShortname());
                }
                if (((FundingTreeType)fundingTree.get()).getFunder().getJurisdiction() != null) {
                    jurisdiction = OpenAIREFundingDataProvider.encodeValue(((FundingTreeType)fundingTree.get()).getFunder().getJurisdiction());
                }
            }
            if (!(funding = (fundingHelper = new FundingHelper(((FundingTreeType)fundingTree.get()).getFundingLevel2OrFundingLevel1OrFundingLevel0())).getFirstAvailableFunding().stream().findFirst()).isEmpty()) {
                fundingName = OpenAIREFundingDataProvider.encodeValue(((FundingType)funding.get()).getName());
            }
        }
        if (!(optCode = projectHelper.getCodes().stream().findFirst()).isEmpty()) {
            code = OpenAIREFundingDataProvider.encodeValue((String)optCode.get());
        }
        return String.format("%s/%s/%s/%s/%s", prefix, funderShortName, fundingName, code, jurisdiction);
    }

    private static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static class ExternalDataObjectBuilder {
        ExternalDataObject externalDataObject;

        public ExternalDataObjectBuilder(Project project) {
            String funderIdPrefix = "urn:openaire:";
            this.externalDataObject = new ExternalDataObject();
            ProjectHelper projectHelper = new ProjectHelper(project.getCodeOrTitleOrAcronym());
            for (FundingTreeType fundingTree : projectHelper.getFundingTreeTypes()) {
                FunderType funder = fundingTree.getFunder();
                this.addFunderName(funder.getName());
                this.addFunderID(funderIdPrefix + funder.getId());
                this.addFunderJuristiction(funder.getJurisdiction());
                FundingHelper fundingHelper = new FundingHelper(fundingTree.getFundingLevel2OrFundingLevel1OrFundingLevel0());
                for (FundingType funding : fundingHelper.getFirstAvailableFunding()) {
                    this.addFundingStream(funding.getDescription());
                }
            }
            for (String title : projectHelper.getTitles()) {
                this.addAwardTitle(title);
                this.setDisplayValue(title);
                this.setValue(title);
            }
            for (String code : projectHelper.getCodes()) {
                this.addAwardNumber(code);
            }
            for (String url : projectHelper.getWebsiteUrls()) {
                this.addAwardURI(url);
            }
            for (String acronym : projectHelper.getAcronyms()) {
                this.addFundingItemAcronym(acronym);
            }
            for (String keyword : projectHelper.getKeywords()) {
                this.addSubject(keyword);
            }
        }

        public ExternalDataObjectBuilder setSource(String source) {
            this.externalDataObject.setSource(source);
            return this;
        }

        public ExternalDataObjectBuilder setDisplayValue(String displayName) {
            this.externalDataObject.setDisplayValue(displayName);
            return this;
        }

        public ExternalDataObjectBuilder setValue(String value) {
            this.externalDataObject.setValue(value);
            return this;
        }

        public ExternalDataObjectBuilder setId(String id) {
            String base64Id = Base64.getEncoder().encodeToString(id.getBytes());
            this.externalDataObject.setId(base64Id);
            return this;
        }

        public ExternalDataObjectBuilder addIdentifier(String identifier) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "identifier", null, null, identifier));
            return this;
        }

        public ExternalDataObjectBuilder addFunderName(String funderName) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("project", "funder", "name", null, funderName));
            return this;
        }

        public ExternalDataObjectBuilder addFunderID(String funderID) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("project", "funder", "identifier", null, funderID));
            return this;
        }

        public ExternalDataObjectBuilder addAwardTitle(String awardTitle) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", null, null, awardTitle));
            return this;
        }

        public ExternalDataObjectBuilder addFundingStream(String fundingStream) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("oaire", "fundingStream", null, null, fundingStream));
            return this;
        }

        public ExternalDataObjectBuilder addAwardNumber(String awardNumber) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("oaire", "awardNumber", null, null, awardNumber));
            return this;
        }

        public ExternalDataObjectBuilder addAwardURI(String websiteUrl) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("oaire", "awardURI", null, null, websiteUrl));
            return this;
        }

        public ExternalDataObjectBuilder addFundingItemAcronym(String fundingItemAcronym) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", "alternative", null, fundingItemAcronym));
            return this;
        }

        public ExternalDataObjectBuilder addFunderJuristiction(String funderJuristiction) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "coverage", "spatial", null, funderJuristiction));
            return this;
        }

        public ExternalDataObjectBuilder addDescription(String description) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "description", null, null, description));
            return this;
        }

        public ExternalDataObjectBuilder addSubject(String subject) {
            this.externalDataObject.addMetadata(new MetadataValueDTO("dc", "subject", null, null, subject));
            return this;
        }

        public ExternalDataObject build() {
            return this.externalDataObject;
        }
    }
}

