/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;
import org.dspace.handle.Handle;
import org.dspace.handle.Handle_;
import org.dspace.handle.dao.HandleDAO;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.internal.StandardDialectResolver;
import org.hibernate.engine.jdbc.dialect.spi.DatabaseMetaDataDialectResolutionInfoAdapter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.jdbc.ReturningWork;

public class HandleDAOImpl
extends AbstractHibernateDAO<Handle>
implements HandleDAO {
    private static final String HANDLE_SEQUENCE = "handle_seq";

    protected HandleDAOImpl() {
    }

    @Override
    public List<Handle> getHandlesByDSpaceObject(Context context, DSpaceObject dso) throws SQLException {
        if (dso == null) {
            return Collections.emptyList();
        }
        Query query = this.createQuery(context, "SELECT h FROM Handle h LEFT JOIN FETCH h.dso WHERE h.dso.id = :id ");
        query.setParameter("id", (Object)dso.getID());
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return this.list(query);
    }

    @Override
    public Handle findByHandle(Context context, String handle) throws SQLException {
        Query query = this.createQuery(context, "SELECT h FROM Handle h LEFT JOIN FETCH h.dso WHERE h.handle = :handle ");
        query.setParameter("handle", (Object)handle);
        query.setHint("org.hibernate.cacheable", (Object)Boolean.TRUE);
        return (Handle)this.singleResult(query);
    }

    @Override
    public List<Handle> findByPrefix(Context context, String prefix) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Handle> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Handle.class);
        Root handleRoot = criteriaQuery.from(Handle.class);
        criteriaQuery.select((Selection)handleRoot);
        criteriaQuery.where((Expression)criteriaBuilder.like((Expression)handleRoot.get(Handle_.handle), prefix + "%"));
        return this.list(context, criteriaQuery, false, Handle.class, -1, -1);
    }

    @Override
    public long countHandlesByPrefix(Context context, String prefix) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root handleRoot = criteriaQuery.from(Handle.class);
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)criteriaQuery.from(Handle.class)));
        criteriaQuery.where((Expression)criteriaBuilder.like((Expression)handleRoot.get(Handle_.handle), prefix + "%"));
        return this.countLong(context, criteriaQuery, criteriaBuilder, handleRoot);
    }

    @Override
    public int updateHandlesWithNewPrefix(Context context, String newPrefix, String oldPrefix) throws SQLException {
        String hql = "UPDATE Handle set handle = concat(:newPrefix, '/', substring(handle, :oldPrefixLength + 2)) WHERE handle like concat(:oldPrefix,'%')";
        Query query = this.createQuery(context, hql);
        query.setParameter("newPrefix", (Object)newPrefix);
        query.setParameter("oldPrefixLength", (Object)oldPrefix.length());
        query.setParameter("oldPrefix", (Object)oldPrefix);
        return query.executeUpdate();
    }

    @Override
    public int countRows(Context context) throws SQLException {
        return this.count(this.createQuery(context, "SELECT count(*) FROM Handle"));
    }

    @Override
    public Long getNextHandleSuffix(Context context) throws SQLException {
        ReturningWork<Long> nextValReturningWork = new ReturningWork<Long>(){

            public Long execute(Connection connection) throws SQLException {
                Long nextVal = 0L;
                StandardDialectResolver dialectResolver = new StandardDialectResolver();
                Dialect dialect = dialectResolver.resolveDialect((DialectResolutionInfo)new DatabaseMetaDataDialectResolutionInfoAdapter(connection.getMetaData()));
                try (PreparedStatement preparedStatement = connection.prepareStatement(dialect.getSequenceNextValString(HandleDAOImpl.HANDLE_SEQUENCE));
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        nextVal = resultSet.getLong(1);
                    }
                }
                return nextVal;
            }
        };
        return (Long)this.getHibernateSession(context).doReturningWork((ReturningWork)nextValReturningWork);
    }
}

