/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.utils.DSpace;
import org.dspace.workflow.factory.WorkflowServiceFactory;

public class DOIConsumer
implements Consumer {
    private static Logger log = LogManager.getLogger(DOIConsumer.class);

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        if (event.getSubjectType() != 2) {
            log.warn("DOIConsumer should not have been given this kind of subject in an event, skipping: " + event.toString());
            return;
        }
        if (4 != event.getEventType()) {
            log.warn("DOIConsumer should not have been given this kind of event type, skipping: " + event.toString());
            return;
        }
        DSpaceObject dso = event.getSubject(ctx);
        if (!(dso instanceof Item)) {
            log.debug("DOIConsumer got an event whose subject was not an item, skipping: " + event.toString());
            return;
        }
        Item item = (Item)dso;
        if (ContentServiceFactory.getInstance().getWorkspaceItemService().findByItem(ctx, item) != null || WorkflowServiceFactory.getInstance().getWorkflowItemService().findByItem(ctx, item) != null) {
            return;
        }
        DOIIdentifierProvider provider = (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class);
        String doi = null;
        try {
            doi = provider.lookup(ctx, dso);
        }
        catch (IdentifierNotFoundException identifierNotFoundException) {
            // empty catch block
        }
        if (doi == null) {
            log.debug("DOIConsumer cannot handles items without DOIs, skipping: " + event.toString());
            return;
        }
        try {
            provider.updateMetadata(ctx, dso, doi);
        }
        catch (IllegalArgumentException ex) {
            log.warn("DOIConsumer caught an IdentifierException.", (Throwable)ex);
        }
        catch (IdentifierException ex) {
            log.warn("DOIConsumer cannot update metadata for Item with ID " + item.getID() + " and DOI " + doi + ".", (Throwable)ex);
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

