/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.iiif.CacheEvictBeanLocator;
import org.dspace.iiif.CacheEvictService;

public class IIIFCacheEventConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(IIIFCacheEventConsumer.class);
    private boolean clearAll = false;
    private final Set<DSpaceObject> toEvictFromManifestCache = new HashSet<DSpaceObject>();

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        int st = event.getSubjectType();
        if (st != 1 && st != 2 && st != 0) {
            return;
        }
        DSpaceObject subject = event.getSubject(ctx);
        int et = event.getEventType();
        if (et == 32 || et == 16) {
            log.warn("IIIF event consumer cannot remove a single item from the cache when a bundle is deleted. The entire cache will be cleared.");
            this.clearAll = true;
        }
        if (st == 1) {
            if ((et == 8 || et == 2 || et == 4 || et == 16 || et == 32) && subject != null) {
                subject = ((Bundle)subject).getItems().get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Transforming Bundle event into Item event for " + subject.getID());
                }
            } else {
                return;
            }
        }
        if (st == 0) {
            if (et == 32 || et == 16) {
                log.warn("IIIF event consumer cannot remove a single item from the cache when a bitstream is deleted. The entire cache will be cleared.");
                this.clearAll = true;
            }
            if ((et == 8 || et == 4) && subject != null) {
                Bundle bundle = ((Bitstream)subject).getBundles().get(0);
                subject = bundle.getItems().get(0);
                if (log.isDebugEnabled()) {
                    log.debug("Transforming Bitstream event into Item event for " + subject.getID());
                }
            } else {
                return;
            }
        }
        if (st == 2 && et == 8) {
            return;
        }
        switch (et) {
            case 8: {
                this.toEvictFromManifestCache.add(subject);
                break;
            }
            case 2: {
                this.toEvictFromManifestCache.add(subject);
                break;
            }
            case 4: {
                this.toEvictFromManifestCache.add(subject);
                break;
            }
            case 16: {
                this.toEvictFromManifestCache.add(subject);
                break;
            }
            case 32: {
                this.toEvictFromManifestCache.add(subject);
                break;
            }
            default: {
                log.warn("IIIFCacheEventConsumer should not have been given this kind of subject in an event, skipping: " + event.toString());
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
        CacheEvictService cacheEvictService = CacheEvictBeanLocator.getCacheEvictService();
        if (cacheEvictService != null) {
            if (this.clearAll) {
                cacheEvictService.evictAllCacheValues();
            } else {
                for (DSpaceObject dso : this.toEvictFromManifestCache) {
                    UUID uuid = dso.getID();
                    cacheEvictService.evictSingleCacheValue(uuid.toString());
                }
            }
        }
        this.clearAll = false;
        this.toEvictFromManifestCache.clear();
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

