/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.license.CCLicense;
import org.dspace.license.CCLicenseConnectorService;
import org.dspace.license.CCLicenseField;
import org.dspace.license.CCLicenseFieldEnum;
import org.dspace.license.service.CreativeCommonsService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class CreativeCommonsServiceImpl
implements CreativeCommonsService,
InitializingBean {
    private static Logger log = LogManager.getLogger(CreativeCommonsServiceImpl.class);
    protected static final String CC_BS_SOURCE = "org.dspace.license.CreativeCommons";
    @Deprecated
    protected static final String BSN_LICENSE_URL = "license_url";
    @Deprecated
    protected static final String BSN_LICENSE_TEXT = "license_text";
    protected static final String BSN_LICENSE_RDF = "license_rdf";
    protected Templates templates;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected BitstreamFormatService bitstreamFormatService;
    @Autowired(required=true)
    protected BundleService bundleService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired
    protected CCLicenseConnectorService ccLicenseConnectorService;
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private String defaultLanguage;
    private String jurisdiction;
    private static final String JURISDICTION_KEY = "jurisdiction";
    private Map<String, Map<String, CCLicense>> ccLicenses;

    protected CreativeCommonsServiceImpl() {
    }

    public void afterPropertiesSet() throws Exception {
        String proxyHost = this.configurationService.getProperty("http.proxy.host");
        String proxyPort = this.configurationService.getProperty("http.proxy.port");
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
            System.setProperty("http.proxyHost", proxyHost);
            System.setProperty("http.proxyPort", proxyPort);
        }
        this.ccLicenses = new HashMap<String, Map<String, CCLicense>>();
        this.defaultLanguage = this.configurationService.getProperty("cc.license.locale", "en");
        this.jurisdiction = this.configurationService.getProperty("cc.license.jurisdiction", "");
        try {
            this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(CreativeCommonsServiceImpl.class.getResourceAsStream("CreativeCommons.xsl")));
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected Bundle getCcBundle(Context context, Item item) throws SQLException, AuthorizeException, IOException {
        List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
        if (bundles.size() > 0 && bundles.get(0) != null) {
            this.itemService.removeBundle(context, item, bundles.get(0));
        }
        return this.bundleService.create(context, item, "CC-LICENSE");
    }

    @Override
    public void setLicenseRDF(Context context, Item item, String licenseRdf) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = this.getCcBundle(context, item);
        BitstreamFormat bs_rdf_format = this.bitstreamFormatService.findByShortDescription(context, "RDF XML");
        this.setBitstreamFromBytes(context, item, bundle, BSN_LICENSE_RDF, bs_rdf_format, licenseRdf.getBytes());
    }

    @Override
    public void setLicense(Context context, Item item, InputStream licenseStm, String mimeType) throws SQLException, IOException, AuthorizeException {
        Bundle bundle = this.getCcBundle(context, item);
        BitstreamFormat bs_format = mimeType.equalsIgnoreCase("text/xml") ? this.bitstreamFormatService.findByShortDescription(context, "CC License") : (mimeType.equalsIgnoreCase("text/rdf") ? this.bitstreamFormatService.findByShortDescription(context, "RDF XML") : this.bitstreamFormatService.findByShortDescription(context, "License"));
        Bitstream bs = this.bitstreamService.create(context, bundle, licenseStm);
        bs.setSource(context, CC_BS_SOURCE);
        bs.setName(context, mimeType != null && (mimeType.equalsIgnoreCase("text/xml") || mimeType.equalsIgnoreCase("text/rdf")) ? BSN_LICENSE_RDF : BSN_LICENSE_TEXT);
        bs.setFormat(context, bs_format);
        this.bitstreamService.update(context, bs);
    }

    @Override
    public void removeLicenseFile(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
        if (bundles.size() > 0 && bundles.get(0) != null) {
            this.itemService.removeBundle(context, item, bundles.get(0));
        }
    }

    @Override
    public Bitstream getLicenseRdfBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return this.getBitstream(item, BSN_LICENSE_RDF);
    }

    @Override
    @Deprecated
    public Bitstream getLicenseTextBitstream(Item item) throws SQLException, IOException, AuthorizeException {
        return this.getBitstream(item, BSN_LICENSE_TEXT);
    }

    @Override
    public String getLicenseURL(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        String licenseUri = this.getCCField("uri");
        if (StringUtils.isNotBlank((CharSequence)licenseUri)) {
            return this.getLicenseURI(item);
        }
        return this.getStringFromBitstream(context, item, BSN_LICENSE_URL);
    }

    @Override
    public String getLicenseURI(Item item) {
        String metadata;
        String licenseUriField = this.getCCField("uri");
        if (StringUtils.isNotBlank((CharSequence)licenseUriField) && StringUtils.isNotBlank((CharSequence)(metadata = this.itemService.getMetadata(item, licenseUriField)))) {
            return metadata;
        }
        return null;
    }

    @Override
    public String getLicenseName(Item item) {
        String metadata;
        String licenseNameField = this.getCCField("name");
        if (StringUtils.isNotBlank((CharSequence)licenseNameField) && StringUtils.isNotBlank((CharSequence)(metadata = this.itemService.getMetadata(item, licenseNameField)))) {
            return metadata;
        }
        return null;
    }

    @Override
    public String fetchLicenseRDF(Document license) {
        StringWriter result = new StringWriter();
        try {
            this.templates.newTransformer().transform((Source)new JDOMSource(license), new StreamResult(result));
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return result.getBuffer().toString();
    }

    protected void setBitstreamFromBytes(Context context, Item item, Bundle bundle, String bitstream_name, BitstreamFormat format, byte[] bytes) throws SQLException, IOException, AuthorizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        Bitstream bs = this.bitstreamService.create(context, bundle, bais);
        bs.setName(context, bitstream_name);
        bs.setSource(context, CC_BS_SOURCE);
        bs.setFormat(context, format);
        this.bitstreamService.update(context, bs);
    }

    protected String getStringFromBitstream(Context context, Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        byte[] bytes = this.getBytesFromBitstream(context, item, bitstream_name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    protected Bitstream getBitstream(Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bundle cc_bundle = null;
        try {
            List<Bundle> bundles = this.itemService.getBundles(item, "CC-LICENSE");
            if (bundles == null || bundles.size() <= 0) {
                return null;
            }
            cc_bundle = bundles.get(0);
        }
        catch (Exception exc) {
            return null;
        }
        return this.bundleService.getBitstreamByName(cc_bundle, bitstream_name);
    }

    protected byte[] getBytesFromBitstream(Context context, Item item, String bitstream_name) throws SQLException, IOException, AuthorizeException {
        Bitstream bs = this.getBitstream(item, bitstream_name);
        if (bs == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utils.copy(this.bitstreamService.retrieve(context, bs), baos);
        return baos.toByteArray();
    }

    @Override
    public String getCCField(String fieldId) {
        return this.configurationService.getProperty("cc.license." + fieldId);
    }

    @Override
    public void removeLicense(Context context, Item item) throws AuthorizeException, IOException, SQLException {
        String uriField = this.getCCField("uri");
        String nameField = this.getCCField("name");
        String licenseUri = this.itemService.getMetadata(item, uriField);
        if (licenseUri != null) {
            this.removeLicenseField(context, item, uriField);
            if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
                this.removeLicenseField(context, item, nameField);
            }
            if (this.configurationService.getBooleanProperty("cc.submit.addbitstream")) {
                this.removeLicenseFile(context, item);
            }
        }
    }

    private void removeLicenseField(Context context, Item item, String field) throws SQLException {
        String[] params = this.splitField(field);
        this.itemService.clearMetadata(context, item, params[0], params[1], params[2], params[3]);
    }

    private void addLicenseField(Context context, Item item, String field, String value) throws SQLException {
        String[] params = this.splitField(field);
        this.itemService.addMetadata(context, item, params[0], params[1], params[2], params[3], value);
    }

    @Override
    public List<CCLicense> findAllCCLicenses() {
        return this.findAllCCLicenses(this.defaultLanguage);
    }

    @Override
    public List<CCLicense> findAllCCLicenses(String language) {
        if (!this.ccLicenses.containsKey(language)) {
            this.initLicenses(language);
        }
        return new LinkedList<CCLicense>(this.ccLicenses.get(language).values());
    }

    @Override
    public CCLicense findOne(String id) {
        return this.findOne(id, this.defaultLanguage);
    }

    @Override
    public CCLicense findOne(String id, String language) {
        Map<String, CCLicense> licenseMap;
        if (!this.ccLicenses.containsKey(language)) {
            this.initLicenses(language);
        }
        if ((licenseMap = this.ccLicenses.get(language)).containsKey(id)) {
            return licenseMap.get(id);
        }
        return null;
    }

    private void initLicenses(String language) {
        Map<String, CCLicense> licenseMap = this.ccLicenseConnectorService.retrieveLicenses(language);
        this.ccLicenses.put(language, licenseMap);
    }

    @Override
    public String retrieveLicenseUri(String licenseId, Map<String, String> answerMap) {
        return this.retrieveLicenseUri(licenseId, this.defaultLanguage, answerMap);
    }

    @Override
    public String retrieveLicenseUri(String licenseId, String language, Map<String, String> answerMap) {
        return this.ccLicenseConnectorService.retrieveRightsByQuestion(licenseId, language, answerMap);
    }

    @Override
    public boolean verifyLicenseInformation(String licenseId, Map<String, String> fullAnswerMap) {
        return this.verifyLicenseInformation(licenseId, this.defaultLanguage, fullAnswerMap);
    }

    @Override
    public boolean verifyLicenseInformation(String licenseId, String language, Map<String, String> fullAnswerMap) {
        CCLicense ccLicense = this.findOne(licenseId, language);
        List<CCLicenseField> ccLicenseFieldList = ccLicense.getCcLicenseFieldList();
        for (String field : fullAnswerMap.keySet()) {
            CCLicenseField ccLicenseField = this.findCCLicenseField(field, ccLicenseFieldList);
            if (ccLicenseField == null) {
                return false;
            }
            if (this.containsAnswerEnum(fullAnswerMap.get(field), ccLicenseField)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> retrieveFullAnswerMap(String licenseId, Map<String, String> answerMap) {
        return this.retrieveFullAnswerMap(licenseId, this.defaultLanguage, answerMap);
    }

    @Override
    public Map<String, String> retrieveFullAnswerMap(String licenseId, String language, Map<String, String> answerMap) {
        CCLicense ccLicense = this.findOne(licenseId, language);
        if (ccLicense == null) {
            return null;
        }
        HashMap<String, String> fullParamMap = new HashMap<String, String>(answerMap);
        List<CCLicenseField> ccLicenseFieldList = ccLicense.getCcLicenseFieldList();
        for (CCLicenseField ccLicenseField : ccLicenseFieldList) {
            if (fullParamMap.containsKey(ccLicenseField.getId())) continue;
            fullParamMap.put(ccLicenseField.getId(), "");
        }
        this.updateJurisdiction(fullParamMap);
        return fullParamMap;
    }

    private void updateJurisdiction(Map<String, String> fullParamMap) {
        if (fullParamMap.containsKey(JURISDICTION_KEY)) {
            fullParamMap.put(JURISDICTION_KEY, this.jurisdiction);
        }
    }

    private boolean containsAnswerEnum(String enumAnswer, CCLicenseField ccLicenseField) {
        List<CCLicenseFieldEnum> fieldEnums = ccLicenseField.getFieldEnum();
        for (CCLicenseFieldEnum fieldEnum : fieldEnums) {
            if (!StringUtils.equals((CharSequence)fieldEnum.getId(), (CharSequence)enumAnswer)) continue;
            return true;
        }
        return false;
    }

    private CCLicenseField findCCLicenseField(String field, List<CCLicenseField> ccLicenseFieldList) {
        for (CCLicenseField ccLicenseField : ccLicenseFieldList) {
            if (!StringUtils.equals((CharSequence)ccLicenseField.getId(), (CharSequence)field)) continue;
            return ccLicenseField;
        }
        return null;
    }

    @Override
    public boolean updateLicense(Context context, String licenseUri, Item item) throws AuthorizeException, SQLException {
        try {
            Document doc = this.ccLicenseConnectorService.retrieveLicenseRDFDoc(licenseUri);
            if (doc == null) {
                return false;
            }
            String licenseName = this.ccLicenseConnectorService.retrieveLicenseName(doc);
            if (StringUtils.isBlank((CharSequence)licenseName)) {
                return false;
            }
            this.removeLicense(context, item);
            this.addLicense(context, item, licenseUri, licenseName, doc);
            return true;
        }
        catch (IOException e) {
            log.error("Error while updating the license of item: " + item.getID(), (Throwable)e);
            return false;
        }
    }

    @Override
    public void addLicense(Context context, Item item, String licenseUri, String licenseName, Document doc) throws SQLException, IOException, AuthorizeException {
        String uriField = this.getCCField("uri");
        String nameField = this.getCCField("name");
        this.addLicenseField(context, item, uriField, licenseUri);
        if (this.configurationService.getBooleanProperty("cc.submit.addbitstream")) {
            this.setLicenseRDF(context, item, this.fetchLicenseRDF(doc));
        }
        if (this.configurationService.getBooleanProperty("cc.submit.setname")) {
            this.addLicenseField(context, item, nameField, licenseName);
        }
    }

    private String[] splitField(String fieldName) {
        String[] params = new String[4];
        String[] fParams = fieldName.split("\\.");
        for (int i = 0; i < fParams.length; ++i) {
            params[i] = fParams[i];
        }
        params[3] = "*";
        return params;
    }
}

