/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.service.EntityTypeService;
import org.dspace.core.Context;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Event;
import org.springframework.beans.factory.annotation.Autowired;

public class EntityTypeServiceInitializer
implements Callback {
    private final Logger log = LogManager.getLogger(EntityTypeServiceInitializer.class);
    @Autowired(required=true)
    private EntityTypeService entityTypeService;

    private void initEntityTypes() {
        Context context = null;
        try {
            context = new Context();
            context.turnOffAuthorisationSystem();
            this.entityTypeService.initDefaultEntityTypeNames(context);
            context.restoreAuthSystemState();
            context.complete();
        }
        catch (Exception e) {
            this.log.error("Error attempting to add/update default DSpace EntityTypes", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
            }
        }
    }

    public boolean supports(Event event, org.flywaydb.core.api.callback.Context context) {
        return event.equals((Object)Event.AFTER_MIGRATE);
    }

    public boolean canHandleInTransaction(Event event, org.flywaydb.core.api.callback.Context context) {
        return true;
    }

    public void handle(Event event, org.flywaydb.core.api.callback.Context context) {
        this.initEntityTypes();
    }
}

