/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.oidc.OidcClient;
import org.dspace.authenticate.oidc.model.OidcTokenResponseDTO;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.EPersonService;
import org.dspace.services.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OidcAuthenticationBean
implements AuthenticationMethod {
    public static final String OIDC_AUTH_ATTRIBUTE = "oidc";
    private static final String LOGIN_PAGE_URL_FORMAT = "%s?client_id=%s&response_type=code&scope=%s&redirect_uri=%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthenticationBean.class);
    private static final String OIDC_AUTHENTICATED = "oidc.authenticated";
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private OidcClient oidcClient;
    @Autowired
    private EPersonService ePersonService;

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.canSelfRegister();
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        return List.of();
    }

    @Override
    public String getName() {
        return OIDC_AUTH_ATTRIBUTE;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        if (request == null) {
            LOGGER.warn("Unable to authenticate using OIDC because the request object is null.");
            return 5;
        }
        if (request.getAttribute(OIDC_AUTH_ATTRIBUTE) == null) {
            return 4;
        }
        String code = request.getParameter("code");
        if (StringUtils.isEmpty((CharSequence)code)) {
            LOGGER.warn("The incoming request has not code parameter");
            return 4;
        }
        return this.authenticateWithOidc(context, code, request);
    }

    private int authenticateWithOidc(Context context, String code, HttpServletRequest request) throws SQLException {
        OidcTokenResponseDTO accessToken = this.getOidcAccessToken(code);
        if (accessToken == null) {
            LOGGER.warn("No access token retrieved by code");
            return 4;
        }
        Map<String, Object> userInfo = this.getOidcUserInfo(accessToken.getAccessToken());
        String email = this.getAttributeAsString(userInfo, this.getEmailAttribute());
        if (StringUtils.isBlank((CharSequence)email)) {
            LOGGER.warn("No email found in the user info attributes");
            return 4;
        }
        EPerson ePerson = this.ePersonService.findByEmail(context, email);
        if (ePerson != null) {
            request.setAttribute(OIDC_AUTHENTICATED, (Object)true);
            return ePerson.canLogIn() ? this.logInEPerson(context, ePerson) : 5;
        }
        if (!this.canSelfRegister()) {
            LOGGER.warn("Self registration is currently disabled for OIDC, and no ePerson could be found for email: {}", (Object)email);
        }
        return this.canSelfRegister() ? this.registerNewEPerson(context, userInfo, email) : 4;
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        String authorizeUrl = this.configurationService.getProperty("authentication-oidc.authorize-endpoint");
        String clientId = this.configurationService.getProperty("authentication-oidc.client-id");
        String clientSecret = this.configurationService.getProperty("authentication-oidc.client-secret");
        String redirectUri = this.configurationService.getProperty("authentication-oidc.redirect-url");
        String tokenUrl = this.configurationService.getProperty("authentication-oidc.token-endpoint");
        String userInfoUrl = this.configurationService.getProperty("authentication-oidc.user-info-endpoint");
        String[] defaultScopes = new String[]{"openid", "email", "profile"};
        String scopes = String.join((CharSequence)" ", this.configurationService.getArrayProperty("authentication-oidc.scopes", defaultScopes));
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{authorizeUrl, clientId, redirectUri, clientSecret, tokenUrl, userInfoUrl})) {
            LOGGER.error("Missing mandatory configuration properties for OidcAuthenticationBean");
            Map<String, String> map = Map.of("authorizeUrl", authorizeUrl, "clientId", clientId, "redirectUri", redirectUri, "clientSecret", clientSecret, "tokenUrl", tokenUrl, "userInfoUrl", userInfoUrl);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!StringUtils.isBlank((CharSequence)entry.getValue())) continue;
                LOGGER.error(" * {} is missing", (Object)entry.getKey());
            }
            return "";
        }
        try {
            return String.format(LOGIN_PAGE_URL_FORMAT, authorizeUrl, clientId, scopes, URLEncoder.encode(redirectUri, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private int logInEPerson(Context context, EPerson ePerson) {
        context.setCurrentUser(ePerson);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int registerNewEPerson(Context context, Map<String, Object> userInfo, String email) throws SQLException {
        try {
            String lastName;
            context.turnOffAuthorisationSystem();
            EPerson eperson = this.ePersonService.create(context);
            eperson.setNetid(email);
            eperson.setEmail(email);
            String firstName = this.getAttributeAsString(userInfo, this.getFirstNameAttribute());
            if (firstName != null) {
                eperson.setFirstName(context, firstName);
            }
            if ((lastName = this.getAttributeAsString(userInfo, this.getLastNameAttribute())) != null) {
                eperson.setLastName(context, lastName);
            }
            eperson.setCanLogIn(true);
            eperson.setSelfRegistered(true);
            this.ePersonService.update(context, eperson);
            context.setCurrentUser(eperson);
            context.dispatchEvents();
            int n = 1;
            return n;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs registering a new EPerson from OIDC", (Throwable)ex);
            int n = 4;
            return n;
        }
        finally {
            context.restoreAuthSystemState();
        }
    }

    private OidcTokenResponseDTO getOidcAccessToken(String code) {
        try {
            return this.oidcClient.getAccessToken(code);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs retriving the OIDC access_token", (Throwable)ex);
            return null;
        }
    }

    private Map<String, Object> getOidcUserInfo(String accessToken) {
        try {
            return this.oidcClient.getUserInfo(accessToken);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs retriving the OIDC user info", (Throwable)ex);
            return Map.of();
        }
    }

    private String getAttributeAsString(Map<String, Object> userInfo, String attribute) {
        if (StringUtils.isBlank((CharSequence)attribute)) {
            return null;
        }
        return userInfo.containsKey(attribute) ? String.valueOf(userInfo.get(attribute)) : null;
    }

    private String getEmailAttribute() {
        return this.configurationService.getProperty("authentication-oidc.user-info.email", "email");
    }

    private String getFirstNameAttribute() {
        return this.configurationService.getProperty("authentication-oidc.user-info.first-name", "given_name");
    }

    private String getLastNameAttribute() {
        return this.configurationService.getProperty("authentication-oidc.user-info.last-name", "family_name");
    }

    private boolean canSelfRegister() {
        String canSelfRegister = this.configurationService.getProperty("authentication-oidc.can-self-register", "true");
        if (StringUtils.isBlank((CharSequence)canSelfRegister)) {
            return true;
        }
        return BooleanUtils.toBoolean((String)canSelfRegister);
    }

    public OidcClient getOidcClient() {
        return this.oidcClient;
    }

    public void setOidcClient(OidcClient oidcClient) {
        this.oidcClient = oidcClient;
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request != null && context.getCurrentUser() != null && request.getAttribute(OIDC_AUTHENTICATED) != null;
    }
}

