/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.HashMap;
import java.util.Map;
import org.dspace.browse.BrowseException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CrossLinks {
    private Map<String, String> links = new HashMap<String, String>();

    public CrossLinks() throws BrowseException {
        int i = 1;
        while (true) {
            String field = "webui.browse.link." + i;
            ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
            String config = configurationService.getProperty(field);
            if (config == null) break;
            String[] parts = config.split(":");
            if (parts.length != 2) {
                throw new BrowseException("Invalid configuration for " + field + ": " + config);
            }
            this.links.put(parts[1], parts[0]);
            ++i;
        }
    }

    public boolean hasLink(String metadata) {
        return this.links.containsKey(metadata);
    }

    public String getLinkType(String metadata) {
        return this.links.get(metadata);
    }
}

