/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectServiceImpl;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.dao.CommunityDAO;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.SiteService;
import org.dspace.core.Context;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.eperson.Group;
import org.dspace.eperson.service.GroupService;
import org.dspace.event.Event;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.service.IdentifierService;
import org.springframework.beans.factory.annotation.Autowired;

public class CommunityServiceImpl
extends DSpaceObjectServiceImpl<Community>
implements CommunityService {
    private static final Logger log = LogManager.getLogger(CommunityServiceImpl.class);
    @Autowired(required=true)
    protected CommunityDAO communityDAO;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected BitstreamService bitstreamService;
    @Autowired(required=true)
    protected SiteService siteService;
    @Autowired(required=true)
    protected IdentifierService identifierService;

    protected CommunityServiceImpl() {
    }

    @Override
    public Community create(Community parent, Context context) throws SQLException, AuthorizeException {
        return this.create(parent, context, null);
    }

    @Override
    public Community create(Community parent, Context context, String handle) throws SQLException, AuthorizeException {
        return this.create(parent, context, handle, null);
    }

    @Override
    public Community create(Community parent, Context context, String handle, UUID uuid) throws SQLException, AuthorizeException {
        if (!(this.authorizeService.isAdmin(context) || parent != null && this.authorizeService.authorizeActionBoolean(context, parent, 3))) {
            throw new AuthorizeException("Only administrators can create communities");
        }
        Community newCommunity = uuid != null ? this.communityDAO.create(context, new Community(uuid)) : this.communityDAO.create(context, new Community());
        if (parent != null) {
            parent.addSubCommunity(newCommunity);
            newCommunity.addParentCommunity(parent);
        }
        Group anonymousGroup = this.groupService.findByName(context, "Anonymous");
        this.authorizeService.createResourcePolicy(context, newCommunity, anonymousGroup, null, 0, null);
        this.communityDAO.save(context, newCommunity);
        try {
            if (handle == null) {
                this.identifierService.register(context, newCommunity);
            } else {
                this.identifierService.register(context, newCommunity, handle);
            }
        }
        catch (IllegalStateException | IdentifierException ex) {
            throw new IllegalStateException(ex);
        }
        context.addEvent(new Event(1, 4, newCommunity.getID(), newCommunity.getHandle(), this.getIdentifiers(context, newCommunity)));
        if (parent == null) {
            context.addEvent(new Event(8, 5, this.siteService.findSite(context).getID(), 4, newCommunity.getID(), newCommunity.getHandle(), this.getIdentifiers(context, newCommunity)));
        }
        log.info(LogHelper.getHeader(context, "create_community", "community_id=" + newCommunity.getID()) + ",handle=" + newCommunity.getHandle());
        return newCommunity;
    }

    @Override
    public Community find(Context context, UUID id) throws SQLException {
        return (Community)this.communityDAO.findByID(context, Community.class, id);
    }

    @Override
    public List<Community> findAll(Context context) throws SQLException {
        MetadataField sortField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.DC.getName(), "title", null);
        if (sortField == null) {
            throw new IllegalArgumentException("Required metadata field '" + MetadataSchemaEnum.DC.getName() + ".title' doesn't exist!");
        }
        return this.communityDAO.findAll(context, sortField);
    }

    @Override
    public List<Community> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        MetadataField nameField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.DC.getName(), "title", null);
        if (nameField == null) {
            throw new IllegalArgumentException("Required metadata field '" + MetadataSchemaEnum.DC.getName() + ".title' doesn't exist!");
        }
        return this.communityDAO.findAll(context, nameField, limit, offset);
    }

    @Override
    public List<Community> findAllTop(Context context) throws SQLException {
        MetadataField sortField = this.metadataFieldService.findByElement(context, MetadataSchemaEnum.DC.getName(), "title", null);
        if (sortField == null) {
            throw new IllegalArgumentException("Required metadata field '" + MetadataSchemaEnum.DC.getName() + ".title' doesn't exist!");
        }
        return this.communityDAO.findAllNoParent(context, sortField);
    }

    @Override
    public void setMetadataSingleValue(Context context, Community community, MetadataFieldName field, String language, String value) throws MissingResourceException, SQLException {
        if (field.equals(MD_NAME) && (value == null || value.trim().equals(""))) {
            try {
                value = I18nUtil.getMessage("org.dspace.content.untitled");
            }
            catch (MissingResourceException e) {
                value = "Untitled";
            }
        }
        if (value == null) {
            this.clearMetadata(context, community, field.schema, field.element, field.qualifier, "*");
            community.setMetadataModified();
        } else {
            super.setMetadataSingleValue(context, community, field, null, value);
        }
        community.addDetails(field.toString());
    }

    @Override
    public Bitstream setLogo(Context context, Community community, InputStream is) throws AuthorizeException, IOException, SQLException {
        Bitstream oldLogo;
        if (is != null || !this.authorizeService.authorizeActionBoolean(context, community, 2)) {
            this.canEdit(context, community);
        }
        if ((oldLogo = community.getLogo()) != null) {
            log.info(LogHelper.getHeader(context, "remove_logo", "community_id=" + community.getID()));
            community.setLogo(null);
            this.bitstreamService.delete(context, oldLogo);
        }
        if (is != null) {
            Bitstream newLogo = this.bitstreamService.create(context, is);
            community.setLogo(newLogo);
            List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, community, 0);
            this.authorizeService.addPolicies(context, policies, newLogo);
            log.info(LogHelper.getHeader(context, "set_logo", "community_id=" + community.getID() + "logo_bitstream_id=" + newLogo.getID()));
        }
        return community.getLogo();
    }

    @Override
    public void update(Context context, Community community) throws SQLException, AuthorizeException {
        this.canEdit(context, community);
        log.info(LogHelper.getHeader(context, "update_community", "community_id=" + community.getID()));
        super.update(context, community);
        this.communityDAO.save(context, community);
        if (community.isModified()) {
            context.addEvent(new Event(2, 4, community.getID(), null, this.getIdentifiers(context, community)));
            community.clearModified();
        }
        if (community.isMetadataModified()) {
            context.addEvent(new Event(4, 4, community.getID(), community.getDetails(), this.getIdentifiers(context, community)));
            community.clearModified();
        }
        community.clearDetails();
    }

    @Override
    public Group createAdministrators(Context context, Community community) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeManageAdminGroup(context, community);
        Group admins = community.getAdministrators();
        if (admins == null) {
            context.turnOffAuthorisationSystem();
            admins = this.groupService.create(context);
            context.restoreAuthSystemState();
            this.groupService.setName(admins, "COMMUNITY_" + community.getID() + "_ADMIN");
            this.groupService.update(context, admins);
        }
        this.authorizeService.addPolicy(context, (DSpaceObject)community, 11, admins);
        community.setAdmins(admins);
        context.addEvent(new Event(2, 4, community.getID(), null, this.getIdentifiers(context, community)));
        return admins;
    }

    @Override
    public void removeAdministrators(Context context, Community community) throws SQLException, AuthorizeException {
        AuthorizeUtil.authorizeRemoveAdminGroup(context, community);
        if (community.getAdministrators() == null) {
            return;
        }
        community.setAdmins(null);
        context.addEvent(new Event(2, 4, community.getID(), null, this.getIdentifiers(context, community)));
    }

    @Override
    public List<Community> getAllParents(Context context, Community community) throws SQLException {
        ArrayList<Community> parentList = new ArrayList<Community>();
        Community parent = (Community)this.getParentObject(context, community);
        while (parent != null) {
            parentList.add(parent);
            parent = (Community)this.getParentObject(context, parent);
        }
        return parentList;
    }

    @Override
    public List<Community> getAllParents(Context context, Collection collection) throws SQLException {
        ArrayList<Community> result = new ArrayList<Community>();
        List<Community> communities = collection.getCommunities();
        result.addAll(communities);
        for (Community community : communities) {
            result.addAll(this.getAllParents(context, community));
        }
        return result;
    }

    @Override
    public List<Collection> getAllCollections(Context context, Community community) throws SQLException {
        ArrayList<Collection> collectionList = new ArrayList<Collection>();
        List<Community> subCommunities = community.getSubcommunities();
        for (Community subCommunity : subCommunities) {
            this.addCollectionList(subCommunity, collectionList);
        }
        List<Collection> collections = community.getCollections();
        for (Collection collection : collections) {
            collectionList.add(collection);
        }
        return collectionList;
    }

    protected void addCollectionList(Community community, List<Collection> collectionList) throws SQLException {
        for (Community subcommunity : community.getSubcommunities()) {
            this.addCollectionList(subcommunity, collectionList);
        }
        for (Collection collection : community.getCollections()) {
            collectionList.add(collection);
        }
    }

    @Override
    public void addCollection(Context context, Community community, Collection collection) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, community, 3);
        log.info(LogHelper.getHeader(context, "add_collection", "community_id=" + community.getID() + ",collection_id=" + collection.getID()));
        if (!community.getCollections().contains(collection)) {
            community.addCollection(collection);
            collection.addCommunity(community);
        }
        context.addEvent(new Event(8, 4, community.getID(), 3, collection.getID(), community.getHandle(), this.getIdentifiers(context, community)));
    }

    @Override
    public Community createSubcommunity(Context context, Community parentCommunity) throws SQLException, AuthorizeException {
        return this.createSubcommunity(context, parentCommunity, null);
    }

    @Override
    public Community createSubcommunity(Context context, Community parentCommunity, String handle) throws SQLException, AuthorizeException {
        return this.createSubcommunity(context, parentCommunity, handle, null);
    }

    @Override
    public Community createSubcommunity(Context context, Community parentCommunity, String handle, UUID uuid) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, parentCommunity, 3);
        Community c = this.create(parentCommunity, context, handle, uuid);
        this.addSubcommunity(context, parentCommunity, c);
        return c;
    }

    @Override
    public void addSubcommunity(Context context, Community parentCommunity, Community childCommunity) throws SQLException, AuthorizeException {
        this.authorizeService.authorizeAction(context, parentCommunity, 3);
        log.info(LogHelper.getHeader(context, "add_subcommunity", "parent_comm_id=" + parentCommunity.getID() + ",child_comm_id=" + childCommunity.getID()));
        if (!parentCommunity.getSubcommunities().contains(childCommunity)) {
            parentCommunity.addSubCommunity(childCommunity);
            childCommunity.addParentCommunity(parentCommunity);
        }
        context.addEvent(new Event(8, 4, parentCommunity.getID(), 4, childCommunity.getID(), parentCommunity.getHandle(), this.getIdentifiers(context, parentCommunity)));
    }

    @Override
    public void removeCollection(Context context, Community community, Collection collection) throws SQLException, AuthorizeException, IOException {
        this.authorizeService.authorizeAction(context, community, 4);
        ArrayList<String> removedIdentifiers = this.collectionService.getIdentifiers(context, collection);
        String removedHandle = collection.getHandle();
        UUID removedId = collection.getID();
        if (collection.getCommunities().size() == 1) {
            this.collectionService.delete(context, collection);
        } else {
            community.removeCollection(collection);
            collection.removeCommunity(community);
        }
        log.info(LogHelper.getHeader(context, "remove_collection", "community_id=" + community.getID() + ",collection_id=" + collection.getID()));
        context.addEvent(new Event(16, 4, community.getID(), 3, removedId, removedHandle, removedIdentifiers));
    }

    @Override
    public void removeSubcommunity(Context context, Community parentCommunity, Community childCommunity) throws SQLException, AuthorizeException, IOException {
        this.authorizeService.authorizeAction(context, parentCommunity, 4);
        ArrayList<String> removedIdentifiers = this.getIdentifiers(context, childCommunity);
        String removedHandle = childCommunity.getHandle();
        UUID removedId = childCommunity.getID();
        this.rawDelete(context, childCommunity);
        log.info(LogHelper.getHeader(context, "remove_subcommunity", "parent_comm_id=" + parentCommunity.getID() + ",child_comm_id=" + childCommunity.getID()));
        context.addEvent(new Event(16, 4, parentCommunity.getID(), 4, removedId, removedHandle, removedIdentifiers));
    }

    @Override
    public void delete(Context context, Community community) throws SQLException, AuthorizeException, IOException {
        if (!this.authorizeService.authorizeActionBoolean(context, this.getParentObject(context, community), 4)) {
            this.authorizeService.authorizeAction(context, community, 2);
        }
        ArrayList<String> removedIdentifiers = this.getIdentifiers(context, community);
        String removedHandle = community.getHandle();
        UUID removedId = community.getID();
        Community parent = (Community)this.getParentObject(context, community);
        if (parent != null) {
            for (Community subCommunity : community.getSubcommunities()) {
                community.removeSubCommunity(subCommunity);
                this.delete(context, subCommunity);
            }
            this.removeSubcommunity(context, parent, community);
            return;
        }
        this.rawDelete(context, community);
        context.addEvent(new Event(16, 5, this.siteService.findSite(context).getID(), 4, removedId, removedHandle, removedIdentifiers));
    }

    @Override
    public int getSupportsTypeConstant() {
        return 4;
    }

    protected void rawDelete(Context context, Community community) throws SQLException, AuthorizeException, IOException {
        log.info(LogHelper.getHeader(context, "delete_community", "community_id=" + community.getID()));
        context.addEvent(new Event(32, 4, community.getID(), community.getHandle(), this.getIdentifiers(context, community)));
        for (Collection collection : community.getCollections()) {
            community.removeCollection(collection);
            this.removeCollection(context, community, collection);
        }
        for (Community subComm : community.getSubcommunities()) {
            community.removeSubCommunity(subComm);
            this.delete(context, subComm);
        }
        this.setLogo(context, community, null);
        this.handleService.unbindHandle(context, community);
        Community parent = (Community)this.getParentObject(context, community);
        if (parent != null) {
            community.removeParentCommunity(parent);
            parent.removeSubCommunity(community);
        }
        Group g = community.getAdministrators();
        this.communityDAO.delete(context, community);
        if (g != null) {
            this.groupService.delete(context, g);
        }
    }

    @Override
    public boolean canEditBoolean(Context context, Community community) throws SQLException {
        try {
            this.canEdit(context, community);
            return true;
        }
        catch (AuthorizeException e) {
            return false;
        }
    }

    @Override
    public void canEdit(Context context, Community community) throws AuthorizeException, SQLException {
        List<Community> parents = this.getAllParents(context, community);
        for (Community parent : parents) {
            if (this.authorizeService.authorizeActionBoolean(context, parent, 1)) {
                return;
            }
            if (!this.authorizeService.authorizeActionBoolean(context, parent, 3)) continue;
            return;
        }
        this.authorizeService.authorizeAction(context, community, 1);
    }

    @Override
    public Community findByAdminGroup(Context context, Group group) throws SQLException {
        return this.communityDAO.findByAdminGroup(context, group);
    }

    @Override
    public List<Community> findAuthorized(Context context, List<Integer> actions) throws SQLException {
        return this.communityDAO.findAuthorized(context, context.getCurrentUser(), actions);
    }

    @Override
    public List<Community> findAuthorizedGroupMapped(Context context, List<Integer> actions) throws SQLException {
        return this.communityDAO.findAuthorizedByGroup(context, context.getCurrentUser(), actions);
    }

    @Override
    public DSpaceObject getAdminObject(Context context, Community community, int action) throws SQLException {
        DSpaceObject adminObject = null;
        switch (action) {
            case 4: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementDeletion() || (adminObject = this.getParentObject(context, community)) != null) break;
                adminObject = community;
                break;
            }
            case 3: {
                if (!AuthorizeConfiguration.canCommunityAdminPerformSubelementCreation()) break;
                adminObject = community;
                break;
            }
            default: {
                adminObject = community;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject(Context context, Community community) throws SQLException {
        List<Community> parentCommunities = community.getParentCommunities();
        if (CollectionUtils.isNotEmpty(parentCommunities)) {
            return parentCommunities.iterator().next();
        }
        return null;
    }

    @Override
    public void updateLastModified(Context context, Community community) {
        context.addEvent(new Event(2, 4, community.getID(), null, this.getIdentifiers(context, community)));
    }

    @Override
    public Community findByIdOrLegacyId(Context context, String id) throws SQLException {
        if (StringUtils.isNumeric((CharSequence)id)) {
            return this.findByLegacyId(context, Integer.parseInt(id));
        }
        return this.find(context, UUID.fromString(id));
    }

    @Override
    public Community findByLegacyId(Context context, int id) throws SQLException {
        return this.communityDAO.findByLegacyId(context, id, Community.class);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.communityDAO.countRows(context);
    }
}

