/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;
import org.dspace.services.factory.DSpaceServicesFactory;

public class FileTaskQueue
implements TaskQueue {
    private static final Logger log = LogManager.getLogger(TaskQueue.class);
    protected String tqDir;
    protected long readTicket = -1L;
    protected List<Integer> readList = new ArrayList<Integer>();

    public FileTaskQueue() {
        this.tqDir = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("curate.taskqueue.dir");
    }

    @Override
    public String[] queueNames() {
        return new File(this.tqDir).list();
    }

    @Override
    public synchronized void enqueue(String queueName, TaskQueueEntry entry) throws IOException {
        HashSet<TaskQueueEntry> entrySet = new HashSet<TaskQueueEntry>();
        entrySet.add(entry);
        this.enqueue(queueName, entrySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enqueue(String queueName, Set<TaskQueueEntry> entrySet) throws IOException {
        int queueIdx = 0;
        File qDir = this.ensureQueue(queueName);
        while (true) {
            File lock;
            if ((lock = new File(qDir, "lock" + Integer.toString(queueIdx))).createNewFile()) {
                try (BufferedWriter writer = null;){
                    File queue = new File(qDir, "queue" + Integer.toString(queueIdx));
                    writer = new BufferedWriter(new FileWriter(queue, StandardCharsets.UTF_8, true));
                    Iterator<TaskQueueEntry> iter = entrySet.iterator();
                    while (iter.hasNext()) {
                        writer.write(iter.next().toString());
                        writer.newLine();
                    }
                }
                if (lock.delete()) break;
                log.error("Unable to remove lock: " + lock.getName());
                break;
            }
            ++queueIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<TaskQueueEntry> dequeue(String queueName, long ticket) throws IOException {
        HashSet<TaskQueueEntry> entrySet = new HashSet<TaskQueueEntry>();
        if (this.readTicket == -1L) {
            File qDir = this.ensureQueue(queueName);
            this.readTicket = ticket;
            int queueIdx = 0;
            while (true) {
                File queue = new File(qDir, "queue" + Integer.toString(queueIdx));
                File lock = new File(qDir, "lock" + Integer.toString(queueIdx));
                if (!queue.exists() || !lock.createNewFile()) break;
                try (BufferedReader reader = null;){
                    String entryStr;
                    reader = new BufferedReader(new FileReader(queue, StandardCharsets.UTF_8));
                    while ((entryStr = reader.readLine()) != null) {
                        if ((entryStr = entryStr.trim()).length() <= 0) continue;
                        entrySet.add(new TaskQueueEntry(entryStr));
                    }
                }
                this.readList.add(queueIdx);
                ++queueIdx;
            }
        }
        return entrySet;
    }

    @Override
    public synchronized void release(String queueName, long ticket, boolean remove) {
        if (ticket == this.readTicket) {
            this.readTicket = -1L;
            File qDir = this.ensureQueue(queueName);
            for (Integer queueIdx : this.readList) {
                File queue;
                File lock = new File(qDir, "lock" + Integer.toString(queueIdx));
                if (remove && !(queue = new File(qDir, "queue" + Integer.toString(queueIdx))).delete()) {
                    log.error("Unable to delete queue file: " + queue.getName());
                }
                if (lock.delete()) continue;
                log.error("Unable to delete lock file: " + lock.getName());
            }
            this.readList.clear();
        }
    }

    protected File ensureQueue(String queueName) {
        File baseDir = new File(this.tqDir, queueName);
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directories");
        }
        return baseDir;
    }
}

