/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.service.ItemService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.FilteredIdentifierProvider;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotApplicableException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.identifier.doi.DOIIdentifierNotApplicableException;
import org.dspace.identifier.service.DOIService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DOIIdentifierProvider
extends FilteredIdentifierProvider {
    private static final Logger log = LoggerFactory.getLogger(DOIIdentifierProvider.class);
    private DOIConnector connector;
    static final String CFG_PREFIX = "identifier.doi.prefix";
    static final String CFG_NAMESPACE_SEPARATOR = "identifier.doi.namespaceseparator";
    static final char SLASH = '/';
    public static final String MD_SCHEMA = "dc";
    public static final String DOI_ELEMENT = "identifier";
    public static final String DOI_QUALIFIER = "uri";
    public static final Integer TO_BE_REGISTERED = 1;
    public static final Integer TO_BE_RESERVED = 2;
    public static final Integer IS_REGISTERED = 3;
    public static final Integer IS_RESERVED = 4;
    public static final Integer UPDATE_RESERVED = 5;
    public static final Integer UPDATE_REGISTERED = 6;
    public static final Integer UPDATE_BEFORE_REGISTRATION = 7;
    public static final Integer TO_BE_DELETED = 8;
    public static final Integer DELETED = 9;
    @Autowired(required=true)
    protected DOIService doiService;
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected ItemService itemService;
    protected Filter filterService;
    private String PREFIX;
    private String NAMESPACE_SEPARATOR;

    protected DOIIdentifierProvider() {
    }

    protected String getPrefix() {
        if (null == this.PREFIX) {
            this.PREFIX = this.configurationService.getProperty(CFG_PREFIX);
            if (null == this.PREFIX) {
                log.warn("Cannot find DOI prefix in configuration!");
                throw new RuntimeException("Unable to load DOI prefix from configuration. Cannot find property identifier.doi.prefix.");
            }
        }
        return this.PREFIX;
    }

    protected String getNamespaceSeparator() {
        if (null == this.NAMESPACE_SEPARATOR) {
            this.NAMESPACE_SEPARATOR = this.configurationService.getProperty(CFG_NAMESPACE_SEPARATOR);
            if (null == this.NAMESPACE_SEPARATOR) {
                this.NAMESPACE_SEPARATOR = "";
            }
        }
        return this.NAMESPACE_SEPARATOR;
    }

    @Autowired(required=true)
    public void setDOIConnector(DOIConnector connector) {
        this.connector = connector;
    }

    @Override
    public void setFilterService(Filter filterService) {
        this.filterService = filterService;
    }

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return DOI.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        try {
            this.doiService.formatIdentifier(identifier);
        }
        catch (IllegalArgumentException | IdentifierException ex) {
            return false;
        }
        return true;
    }

    @Override
    public String register(Context context, DSpaceObject dso) throws IdentifierException {
        return this.register(context, dso, false);
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.register(context, dso, identifier, false);
    }

    @Override
    public String register(Context context, DSpaceObject dso, boolean skipFilter) throws IdentifierException {
        if (!(dso instanceof Item)) {
            return null;
        }
        String doi = this.mint(context, dso, skipFilter);
        this.register(context, dso, doi, skipFilter);
        return doi;
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier, boolean skipFilter) throws IdentifierException {
        if (!(dso instanceof Item)) {
            return;
        }
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = null;
        try {
            doiRow = this.loadOrCreateDOI(context, dso, doi, skipFilter);
        }
        catch (SQLException ex) {
            log.error("Error in databse connection: " + ex.getMessage());
            throw new RuntimeException("Error in database conncetion.", ex);
        }
        if (DELETED.equals(doiRow.getStatus()) || TO_BE_DELETED.equals(doiRow.getStatus())) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        if (IS_REGISTERED.equals(doiRow.getStatus())) {
            return;
        }
        doiRow.setStatus(TO_BE_REGISTERED);
        try {
            this.doiService.update(context, doiRow);
        }
        catch (SQLException sqle) {
            log.warn("SQLException while changing status of DOI {} to be registered.", (Object)doi);
            throw new RuntimeException(sqle);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException {
        this.reserve(context, dso, identifier, false);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier, boolean skipFilter) throws IdentifierException, IllegalArgumentException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = null;
        try {
            doiRow = this.loadOrCreateDOI(context, dso, doi, skipFilter);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (doiRow.getStatus() != null) {
            return;
        }
        doiRow.setStatus(TO_BE_RESERVED);
        try {
            this.doiService.update(context, doiRow);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
    }

    public void reserveOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        this.reserveOnline(context, dso, identifier, false);
    }

    public void reserveOnline(Context context, DSpaceObject dso, String identifier, boolean skipFilter) throws IdentifierException, IllegalArgumentException, SQLException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = this.loadOrCreateDOI(context, dso, doi, skipFilter);
        if (DELETED.equals(doiRow.getStatus()) || TO_BE_DELETED.equals(doiRow.getStatus())) {
            throw new DOIIdentifierException("You tried to reserve a DOI that is marked as DELETED.", 13);
        }
        this.connector.reserveDOI(context, dso, doi);
        doiRow.setStatus(IS_RESERVED);
        this.doiService.update(context, doiRow);
    }

    public void registerOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        this.registerOnline(context, dso, identifier, false);
    }

    public void registerOnline(Context context, DSpaceObject dso, String identifier, boolean skipFilter) throws IdentifierException, IllegalArgumentException, SQLException {
        log.debug("registerOnline: skipFilter is " + skipFilter);
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = this.loadOrCreateDOI(context, dso, doi, skipFilter);
        if (DELETED.equals(doiRow.getStatus()) || TO_BE_DELETED.equals(doiRow.getStatus())) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        try {
            this.connector.registerDOI(context, dso, doi);
        }
        catch (DOIIdentifierException die) {
            if (die.getCode() == 6) {
                this.reserveOnline(context, dso, identifier, skipFilter);
                this.connector.registerDOI(context, dso, doi);
            }
            throw die;
        }
        try {
            this.saveDOIToObject(context, dso, doi);
        }
        catch (AuthorizeException ae) {
            throw new IdentifierException("Not authorized to save a DOI as metadata of an dso!", ae);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        doiRow.setStatus(IS_REGISTERED);
        this.doiService.update(context, doiRow);
    }

    public void updateMetadata(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        DOI doiRow;
        String doi = this.doiService.formatIdentifier(identifier);
        boolean skipFilter = false;
        if (this.doiService.findDOIByDSpaceObject(context, dso) != null) {
            log.debug("updateMetadata: found DOIByDSpaceObject: " + this.doiService.findDOIByDSpaceObject(context, dso).getDoi());
            skipFilter = true;
        }
        if (DELETED.equals((doiRow = this.loadOrCreateDOI(context, dso, doi, skipFilter)).getStatus()) || TO_BE_DELETED.equals(doiRow.getStatus())) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        if (IS_REGISTERED.equals(doiRow.getStatus())) {
            doiRow.setStatus(UPDATE_REGISTERED);
        } else if (TO_BE_REGISTERED.equals(doiRow.getStatus())) {
            doiRow.setStatus(UPDATE_BEFORE_REGISTRATION);
        } else if (IS_RESERVED.equals(doiRow.getStatus())) {
            doiRow.setStatus(UPDATE_RESERVED);
        } else {
            return;
        }
        this.doiService.update(context, doiRow);
    }

    public void updateMetadataOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, SQLException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = null;
        try {
            doiRow = this.doiService.findByDoi(context, doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            log.warn("SQLException while searching a DOI in our db.", (Throwable)sqle);
            throw new RuntimeException("Unable to retrieve information about a DOI out of database.", sqle);
        }
        if (null == doiRow) {
            log.error("Cannot update metadata for DOI {}: unable to find it in our db.", (Object)doi);
            throw new DOIIdentifierException("Unable to find DOI.", 1);
        }
        if (!Objects.equals(doiRow.getDSpaceObject(), dso)) {
            log.error("Refuse to update metadata of DOI {} with the metadata of  an object ({}/{}) the DOI is not dedicated to.", new Object[]{doi, this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso), dso.getID().toString()});
            throw new DOIIdentifierException("Cannot update DOI metadata: DOI and DSpaceObject does not match!", 10);
        }
        if (DELETED.equals(doiRow.getStatus()) || TO_BE_DELETED.equals(doiRow.getStatus())) {
            throw new DOIIdentifierException("You tried to update the metadataof a DOI that is marked as DELETED.", 13);
        }
        this.connector.updateMetadata(context, dso, doi);
        if (UPDATE_REGISTERED.equals(doiRow.getStatus())) {
            doiRow.setStatus(IS_REGISTERED);
        } else if (UPDATE_BEFORE_REGISTRATION.equals(doiRow.getStatus())) {
            doiRow.setStatus(TO_BE_REGISTERED);
        } else if (UPDATE_RESERVED.equals(doiRow.getStatus())) {
            doiRow.setStatus(IS_RESERVED);
        }
        this.doiService.update(context, doiRow);
    }

    @Override
    public String mint(Context context, DSpaceObject dso) throws IdentifierException {
        return this.mint(context, dso, false);
    }

    @Override
    public String mint(Context context, DSpaceObject dso, boolean skipFilter) throws IdentifierException {
        Object doi = null;
        try {
            doi = this.getDOIByObject(context, dso);
        }
        catch (SQLException e) {
            log.error("Error while attemping to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".");
            throw new RuntimeException("Error while attempting to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", e);
        }
        if (null == doi) {
            try {
                DOI doiRow = this.loadOrCreateDOI(context, dso, null, skipFilter);
                doi = "doi:" + doiRow.getDoi();
            }
            catch (SQLException e) {
                log.error("Error while creating new DOI for Object of ResourceType {} with id {}.", (Object)dso.getType(), (Object)dso.getID());
                throw new RuntimeException("Error while attempting to create a new DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", e);
            }
        }
        return doi;
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        String doi = null;
        try {
            doi = this.doiService.formatIdentifier(identifier);
        }
        catch (IdentifierException e) {
            throw new IdentifierNotResolvableException(e);
        }
        try {
            DSpaceObject dso = this.getObjectByDOI(context, doi);
            if (null == dso) {
                throw new IdentifierNotFoundException();
            }
            return dso;
        }
        catch (SQLException sqle) {
            log.error("SQLException while searching a DOI in our db.", (Throwable)sqle);
            throw new RuntimeException("Unable to retrieve information about a DOI out of database.", sqle);
        }
        catch (IdentifierException e) {
            throw new IdentifierNotResolvableException(e);
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        String doi = null;
        try {
            doi = this.getDOIByObject(context, dso);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving DOI out of database.", e);
        }
        if (null == doi) {
            throw new IdentifierNotFoundException("No DOI for DSpaceObject of type " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + " found.");
        }
        return doi;
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        String doi;
        try {
            doi = this.getDOIByObject(context, dso);
            while (null != doi) {
                this.delete(context, dso, doi);
                doi = this.getDOIByObject(context, dso);
            }
        }
        catch (SQLException ex) {
            log.error("Error while attemping to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while attempting to retrieve information about a DOI for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", ex);
        }
        try {
            doi = this.getDOIOutOfObject(dso);
            while (null != doi) {
                this.removeDOIFromObject(context, dso, doi);
                doi = this.getDOIOutOfObject(dso);
            }
        }
        catch (AuthorizeException ex) {
            log.error("Error while removing a DOI out of the metadata of an " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while removing a DOI out of the metadata of an " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", ex);
        }
        catch (SQLException ex) {
            log.error("Error while removing a DOI out of the metadata of an " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while removing a DOI out of the metadata of an " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + " with ID " + dso.getID() + ".", ex);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = null;
        try {
            doiRow = this.doiService.findByDoi(context, doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (null != doiRow && !Objects.equals(dso, doiRow.getDSpaceObject())) {
            throw new DOIIdentifierException("Trying to delete a DOI out of an object that is not addressed by the DOI.", 10);
        }
        try {
            this.removeDOIFromObject(context, dso, doi);
        }
        catch (AuthorizeException ex) {
            log.error("Not authorized to delete a DOI out of an Item.", (Throwable)ex);
            throw new DOIIdentifierException("Not authorized to delete DOI.", ex, 12);
        }
        catch (SQLException ex) {
            log.error("SQLException occurred while deleting a DOI out of an item: " + ex.getMessage());
            throw new RuntimeException("Error while deleting a DOI out of the metadata of an Item " + dso.getID(), ex);
        }
        if (null != doiRow) {
            doiRow.setDSpaceObject(null);
            if (doiRow.getStatus() == null) {
                doiRow.setStatus(DELETED);
            } else {
                doiRow.setStatus(TO_BE_DELETED);
            }
            try {
                this.doiService.update(context, doiRow);
            }
            catch (SQLException sqle) {
                log.warn("SQLException while changing status of DOI {} to be deleted.", (Object)doi);
                throw new RuntimeException(sqle);
            }
        }
    }

    public void deleteOnline(Context context, String identifier) throws DOIIdentifierException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = null;
        try {
            doiRow = this.doiService.findByDoi(context, doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (null == doiRow) {
            throw new DOIIdentifierException("This identifier: " + identifier + " isn't in our database", 1);
        }
        if (!TO_BE_DELETED.equals(doiRow.getStatus())) {
            log.error("This identifier: {} couldn't be deleted. Delete it first from metadata.", (Object)("doi:" + doiRow.getDoi()));
            throw new IllegalArgumentException("Couldn't delete this identifier:doi:" + doiRow.getDoi() + ". Delete it first from metadata.");
        }
        this.connector.deleteDOI(context, doi);
        doiRow.setStatus(DELETED);
        try {
            this.doiService.update(context, doiRow);
        }
        catch (SQLException sqle) {
            log.warn("SQLException while changing status of DOI {} deleted.", (Object)doi);
            throw new RuntimeException(sqle);
        }
    }

    public DSpaceObject getObjectByDOI(Context context, String identifier) throws SQLException, DOIIdentifierException, IllegalArgumentException {
        String doi = this.doiService.formatIdentifier(identifier);
        DOI doiRow = this.doiService.findByDoi(context, doi.substring("doi:".length()));
        if (null == doiRow) {
            return null;
        }
        if (doiRow.getDSpaceObject() == null) {
            log.error("Found DOI " + doi + " in database, but no assigned Object could be found.");
            throw new IllegalStateException("Found DOI " + doi + " in database, but no assigned Object could be found.");
        }
        return doiRow.getDSpaceObject();
    }

    public String getDOIByObject(Context context, DSpaceObject dso) throws SQLException {
        DOI doiRow = this.doiService.findDOIByDSpaceObject(context, dso, Arrays.asList(DELETED, TO_BE_DELETED));
        if (null == doiRow) {
            return null;
        }
        if (doiRow.getDoi() == null) {
            log.error("A DOI with an empty doi column was found in the database. DSO-Type: " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", ID: " + dso.getID() + ".");
            throw new IllegalStateException("A DOI with an empty doi column was found in the database. DSO-Type: " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", ID: " + dso.getID() + ".");
        }
        return "doi:" + doiRow.getDoi();
    }

    protected DOI loadOrCreateDOI(Context context, DSpaceObject dso, String doiIdentifier) throws SQLException, DOIIdentifierException, IdentifierNotApplicableException {
        return this.loadOrCreateDOI(context, dso, doiIdentifier, false);
    }

    protected DOI loadOrCreateDOI(Context context, DSpaceObject dso, String doiIdentifier, boolean skipFilter) throws SQLException, DOIIdentifierException, IdentifierNotApplicableException {
        DOI doi = null;
        if (null != doiIdentifier) {
            doi = this.doiService.findByDoi(context, (String)(doiIdentifier = ((String)doiIdentifier).substring("doi:".length())));
            if (null != doi) {
                if (doi.getDSpaceObject() == null) {
                    if (doi.getResourceTypeId() != null && doi.getResourceTypeId().intValue() != dso.getType()) {
                        throw new DOIIdentifierException("Cannot reassign previously deleted DOI " + (String)doiIdentifier + " as the resource types of the object it was previously assigned to and the object it shall be assigned to now differ (was: " + Constants.typeText[doi.getResourceTypeId()] + ", trying to assign to " + Constants.typeText[dso.getType()] + ").", 13);
                    }
                } else {
                    if (dso.getID().equals(doi.getDSpaceObject().getID())) {
                        return doi;
                    }
                    throw new DOIIdentifierException("Trying to create a DOI that is already reserved for another object.", 2);
                }
            }
            if (skipFilter) {
                log.warn("loadOrCreateDOI: Skipping default item filter");
            } else {
                this.checkMintable(context, dso);
            }
            if (!((String)doiIdentifier).startsWith(this.getPrefix() + "/")) {
                throw new DOIIdentifierException("Trying to create a DOI that's not part of our Namespace!", 3);
            }
            if (doi == null) {
                doi = this.doiService.create(context);
            }
        } else {
            if (skipFilter) {
                log.warn("loadOrCreateDOI: Skipping default item filter");
            } else {
                this.checkMintable(context, dso);
            }
            doi = this.doiService.create(context);
            doiIdentifier = this.getPrefix() + "/" + this.getNamespaceSeparator() + doi.getID();
        }
        doi.setDoi((String)doiIdentifier);
        doi.setDSpaceObject(dso);
        doi.setStatus(null);
        try {
            this.doiService.update(context, doi);
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot save DOI to database for unknown reason.");
        }
        return doi;
    }

    public String getDOIOutOfObject(DSpaceObject dso) throws DOIIdentifierException {
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ".");
        }
        Item item = (Item)dso;
        List<MetadataValue> metadata = this.itemService.getMetadata(item, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        String leftPart = "http://dx.doi.org/" + this.getPrefix() + "/" + this.getNamespaceSeparator();
        for (MetadataValue id : metadata) {
            if (!id.getValue().startsWith(leftPart)) continue;
            return this.doiService.DOIFromExternalFormat(id.getValue());
        }
        return null;
    }

    protected void saveDOIToObject(Context context, DSpaceObject dso, String doi) throws SQLException, AuthorizeException, IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ".");
        }
        Item item = (Item)dso;
        this.itemService.addMetadata(context, item, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, this.doiService.DOIToExternalForm(doi));
        this.itemService.update(context, item);
    }

    protected void removeDOIFromObject(Context context, DSpaceObject dso, String doi) throws AuthorizeException, SQLException, IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ".");
        }
        Item item = (Item)dso;
        List<MetadataValue> metadata = this.itemService.getMetadata(item, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        ArrayList<String> remainder = new ArrayList<String>();
        for (MetadataValue id : metadata) {
            if (id.getValue().equals(this.doiService.DOIToExternalForm(doi))) continue;
            remainder.add(id.getValue());
        }
        this.itemService.clearMetadata(context, item, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        this.itemService.addMetadata(context, item, MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, remainder);
        this.itemService.update(context, item);
    }

    @Override
    public void checkMintable(Context context, DSpaceObject dso) throws DOIIdentifierNotApplicableException {
        block4: {
            if (this.filterService != null && this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso).equals("ITEM")) {
                try {
                    boolean result = this.filterService.getResult(context, (Item)dso);
                    log.debug("Result of filter for " + dso.getHandle() + " is " + result);
                    if (!result) {
                        throw new DOIIdentifierNotApplicableException("Item " + dso.getHandle() + " was evaluated as 'false' by the item filter, not minting");
                    }
                    break block4;
                }
                catch (LogicalStatementException e) {
                    log.error("Error evaluating item with logical filter: " + e.getLocalizedMessage());
                    throw new DOIIdentifierNotApplicableException(e);
                }
            }
            log.debug("DOI Identifier Provider: filterService is null (ie. don't prevent DOI minting)");
        }
    }
}

