/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.service.components;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.exception.FileMultipleOccurencesException;
import org.dspace.importer.external.exception.FileSourceException;
import org.dspace.importer.external.metadatamapping.AbstractMetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.service.components.FileSource;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public abstract class AbstractPlainMetadataSource
extends AbstractMetadataFieldMapping<PlainMetadataSourceDto>
implements FileSource {
    private List<String> supportedExtensions;

    protected abstract List<PlainMetadataSourceDto> readData(InputStream var1) throws FileSourceException;

    public void setSupportedExtensions(List<String> supportedExtensions) {
        this.supportedExtensions = supportedExtensions;
    }

    @Override
    public List<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    @Override
    public List<ImportRecord> getRecords(InputStream is) throws FileSourceException {
        List<PlainMetadataSourceDto> datas = this.readData(is);
        ArrayList<ImportRecord> records = new ArrayList<ImportRecord>();
        for (PlainMetadataSourceDto item : datas) {
            records.add(this.toRecord(item));
        }
        return records;
    }

    @Override
    public ImportRecord getRecord(InputStream is) throws FileSourceException, FileMultipleOccurencesException {
        List<PlainMetadataSourceDto> datas = this.readData(is);
        if (datas == null || datas.isEmpty()) {
            throw new FileSourceException("File is empty");
        }
        if (datas.size() > 1) {
            throw new FileMultipleOccurencesException("File contains more than one entry (" + datas.size() + " entries");
        }
        return this.toRecord(datas.get(0));
    }

    private ImportRecord toRecord(PlainMetadataSourceDto entry) {
        ArrayList<MetadatumDTO> metadata = new ArrayList<MetadatumDTO>();
        metadata.addAll(this.resultToDCValueMapping(entry));
        return new ImportRecord(metadata);
    }
}

