/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.migration;

import java.sql.SQLException;
import org.apache.commons.cli.Options;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.submit.migration.SubmissionFormsMigration;
import org.springframework.beans.factory.annotation.Autowired;

public class SubmissionFormsMigrationCliScriptConfiguration<T extends SubmissionFormsMigration>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("f", "input-forms", true, "Path to source input-forms.xml file location");
            options.getOption("f").setType(String.class);
            options.addOption("s", "item-submission", true, "Path to source item-submission.xml file location");
            options.getOption("s").setType(String.class);
            options.addOption("h", "help", false, "help");
            options.getOption("h").setType(Boolean.TYPE);
            this.options = options;
        }
        return this.options;
    }
}

