/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class ItemBuilder
extends AbstractDSpaceObjectBuilder<Item> {
    private boolean withdrawn = false;
    private WorkspaceItem workspaceItem;
    private Item item;
    private Group readerGroup = null;

    protected ItemBuilder(Context context) {
        super(context);
    }

    public static ItemBuilder createItem(Context context, Collection col) {
        ItemBuilder builder = new ItemBuilder(context);
        return builder.create(context, col);
    }

    private ItemBuilder create(Context context, Collection col) {
        this.context = context;
        try {
            this.workspaceItem = workspaceItemService.create(context, col, false);
            this.item = this.workspaceItem.getItem();
        }
        catch (Exception e) {
            return (ItemBuilder)this.handleException(e);
        }
        return this;
    }

    public ItemBuilder withTitle(String title) {
        return (ItemBuilder)this.setMetadataSingleValue(this.item, MetadataSchemaEnum.DC.getName(), "title", null, title);
    }

    public ItemBuilder withIssueDate(String issueDate) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "date", "issued", new DCDate(issueDate).toString());
    }

    public ItemBuilder withIdentifierOther(String identifierOther) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "identifier", "other", identifierOther);
    }

    public ItemBuilder withAuthor(String authorName) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "contributor", "author", authorName);
    }

    public ItemBuilder withAuthor(String authorName, String authority, int confidence) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "contributor", "author", null, authorName, authority, confidence);
    }

    public ItemBuilder withPersonIdentifierFirstName(String personIdentifierFirstName) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "givenName", null, personIdentifierFirstName);
    }

    public ItemBuilder withPersonIdentifierLastName(String personIdentifierLastName) {
        return (ItemBuilder)this.addMetadataValue(this.item, "person", "familyName", null, personIdentifierLastName);
    }

    public ItemBuilder withSubject(String subject) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "subject", null, subject);
    }

    public ItemBuilder withSubject(String subject, String authority, int confidence) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "subject", null, null, subject, authority, confidence);
    }

    public ItemBuilder withType(String type) {
        return (ItemBuilder)this.addMetadataValue(this.item, "dc", "type", null, type);
    }

    public ItemBuilder withPublicationIssueNumber(String issueNumber) {
        return (ItemBuilder)this.addMetadataValue(this.item, "publicationissue", "issueNumber", null, issueNumber);
    }

    public ItemBuilder withPublicationVolumeNumber(String volumeNumber) {
        return (ItemBuilder)this.addMetadataValue(this.item, "publicationvolume", "volumeNumber", null, volumeNumber);
    }

    public ItemBuilder withProvenanceData(String provenanceData) {
        return (ItemBuilder)this.addMetadataValue(this.item, MetadataSchemaEnum.DC.getName(), "description", "provenance", provenanceData);
    }

    public ItemBuilder enableIIIF() {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "iiif", "enabled", "true");
    }

    public ItemBuilder disableIIIF() {
        return (ItemBuilder)this.addMetadataValue(this.item, "dspace", "iiif", "enabled", "false");
    }

    public ItemBuilder enableIIIFSearch() {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "search", "enabled", "true");
    }

    public ItemBuilder withIIIFViewingHint(String hint) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "viewing", "hint", hint);
    }

    public ItemBuilder withIIIFCanvasNaming(String naming) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "canvas", "naming", naming);
    }

    public ItemBuilder withIIIFCanvasWidth(int i) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "image", "width", String.valueOf(i));
    }

    public ItemBuilder withIIIFCanvasHeight(int i) {
        return (ItemBuilder)this.addMetadataValue(this.item, "iiif", "image", "height", String.valueOf(i));
    }

    public ItemBuilder withMetadata(String schema, String element, String qualifier, String value) {
        return (ItemBuilder)this.addMetadataValue(this.item, schema, element, qualifier, value);
    }

    public ItemBuilder makeUnDiscoverable() {
        this.item.setDiscoverable(false);
        return this;
    }

    public ItemBuilder withdrawn() {
        this.withdrawn = true;
        return this;
    }

    public ItemBuilder withEmbargoPeriod(String embargoPeriod) {
        return (ItemBuilder)this.setEmbargo(embargoPeriod, (DSpaceObject)this.item);
    }

    public ItemBuilder withReaderGroup(Group group) {
        this.readerGroup = group;
        return this;
    }

    public ItemBuilder withAdminUser(EPerson ePerson) throws SQLException, AuthorizeException {
        return (ItemBuilder)this.setAdminPermission((DSpaceObject)this.item, ePerson, null);
    }

    @Override
    public Item build() {
        try {
            installItemService.installItem(this.context, (InProgressSubmission)this.workspaceItem);
            itemService.update(this.context, (DSpaceObject)this.item);
            if (this.readerGroup != null) {
                this.setOnlyReadPermission((DSpaceObject)this.workspaceItem.getItem(), this.readerGroup, null);
            }
            if (this.withdrawn) {
                itemService.withdraw(this.context, this.item);
            }
            this.context.dispatchEvents();
            indexingService.commit();
            return this.item;
        }
        catch (Exception e) {
            return (Item)this.handleException(e);
        }
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            this.item = (Item)c.reloadEntity((ReloadableEntity)this.item);
            if (this.item != null) {
                this.delete(c, this.item);
                c.complete();
            }
        }
    }

    @Override
    protected DSpaceObjectService<Item> getService() {
        return itemService;
    }

    public static void deleteItem(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Item item = (Item)itemService.find(c, uuid);
            if (item != null) {
                try {
                    itemService.delete(c, (DSpaceObject)item);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }
}

