/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;
import org.dspace.versioning.Version;
import org.dspace.versioning.service.VersioningService;

public class VersionBuilder
extends AbstractBuilder<Version, VersioningService> {
    private static final Logger log = Logger.getLogger(VersionBuilder.class);
    private Version version;

    protected VersionBuilder(Context context) {
        super(context);
    }

    public static VersionBuilder createVersion(Context context, Item item, String summary) {
        VersionBuilder builder = new VersionBuilder(context);
        return builder.create(context, item, summary);
    }

    private VersionBuilder create(Context context, Item item, String summary) {
        try {
            this.context = context;
            this.version = StringUtils.isNotBlank((String)summary) ? this.getService().createNewVersion(context, item, summary) : this.getService().createNewVersion(context, item);
        }
        catch (Exception e) {
            log.error((Object)"Error in VersionBuilder.create(..), error: ", (Throwable)e);
        }
        return this;
    }

    @Override
    public Version build() throws SQLException, AuthorizeException {
        try {
            this.getService().update(this.context, this.version);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            log.error((Object)"Error in VersionBuilder.build(), error: ", (Throwable)e);
        }
        return this.version;
    }

    @Override
    public void delete(Context context, Version version) throws Exception {
        if (Objects.nonNull(version)) {
            this.getService().delete(context, version);
        }
    }

    @Override
    protected VersioningService getService() {
        return versioningService;
    }

    @Override
    public void cleanup() throws Exception {
        this.delete(this.version);
    }

    public void delete(Version version) throws Exception {
        try (Context context = new Context();){
            context.turnOffAuthorisationSystem();
            Version attachedTab = (Version)context.reloadEntity((ReloadableEntity)version);
            if (attachedTab != null) {
                this.getService().delete(context, attachedTab);
            }
            context.complete();
        }
        indexingService.commit();
    }

    public static void delete(Integer id) throws SQLException, IOException, SearchServiceException {
        try (Context context = new Context();){
            context.turnOffAuthorisationSystem();
            Version version = versioningService.getVersion(context, id.intValue());
            if (version != null) {
                versioningService.delete(context, version);
            }
            context.complete();
        }
        indexingService.commit();
    }
}

